% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{ConsensusClustering}
\alias{ConsensusClustering}
\title{Consensus clustering}
\usage{
ConsensusClustering(List, type = c("data", "dist", "clust"),
  distmeasure = c("tanimoto", "tanimoto"), normalize = c(FALSE, FALSE),
  method = c(NULL, NULL), clust = "agnes", linkage = c("flexible",
  "flexible"), alpha = 0.625, nrclusters = c(7, 7), gap = FALSE,
  maxK = 15, votingMethod = c("IVC", "IPVC", "IPC"), optimalk = 7)
}
\arguments{
\item{List}{A list of data matrices. It is assumed the rows are corresponding with the objects.}

\item{type}{indicates whether the provided matrices in "List" are either data matrices, distance
matrices or clustering results obtained from the data. If type="dist" the calculation of the distance
matrices is skipped and if type="clusters" the single source clustering is skipped.
Type should be one of "data", "dist" or "clusters".}

\item{distmeasure}{A vector of the distance measures to be used on each data matrix. Should be one of "tanimoto", "euclidean", "jaccard", "hamming". Defaults to c("tanimoto","tanimoto").}

\item{normalize}{Logical. Indicates whether to normalize the distance matrices or not, defaults to c(FALSE, FALSE) for two data sets. This is recommended if different distance types are used. More details on normalization in \code{Normalization}.}

\item{method}{A method of normalization. Should be one of "Quantile","Fisher-Yates", "standardize","Range" or any of the first letters of these names. Default is c(NULL,NULL) for two data sets.}

\item{clust}{Choice of clustering function (character). Defaults to "agnes".}

\item{linkage}{Choice of inter group dissimilarity (character) for each data set. Defaults to c("flexible", "flexible") for two data sets.}

\item{alpha}{The parameter alpha to be used in the "flexible" linkage of the agnes function. Defaults to 0.625 and is only used if the linkage is set to "flexible"}

\item{nrclusters}{The number of clusters to divide each individual dendrogram in. Default is c(7,7) for two data sets.}

\item{gap}{Logical. Whether the optimal number of clusters should be determined with the gap statistic. Defaults to FALSE.}

\item{maxK}{The maximal number of clusters to investigate in the gap statistic. Default is 15.}

\item{votingMethod}{The method to be performed: "IVC", "IPVC,"IVC".}

\item{optimalk}{An estimate of the final optimal number of clusters. Default is 7.}
}
\value{
The returned value is a list of two elements:
\item{DistM}{A NULL object}
\item{Clust}{The resulting clustering}
The value has class 'Ensemble'.
}
\description{
The \code{ConsensusClustering} includes the ensemble clustering methods IVC, IPVC and IVC which are voting-based consensus methods.
}
\details{
\insertCite{Nguyen2007}{IntClust} propose three EM-like consensus clustering algorithms: Iterative Voting Consensus (IVC), 
Iterative Probabilistic Voting Consensus (IPVC) and Iterative Pairwise Consensus (IPC). Given a number of clusters $k$, the methods 
iteratively compute the cluster centers and reassign each object to the closest center. IVC and IPVC represent the cluster centers 
by a vector of the majority votes of the cluster labels of all points belonging to the cluster in each partition. For the reassignment, 
IVC uses the Hamming distance to compute the distance between the data points and the cluster centers. IPVC is a 
refinement of IVC as the distance function takes into account the proportion that each feature of a point differs from the points in 
the cluster. The IPC algorithms is slightly different since the original clusters are built from a similarity matrix which represents 
the ratio of the number of partitions in which two objects reside in the same cluster. The distance between a data point and a cluster 
center is the average of the similarity values between the data point and the points residing in the cluster. The iteration ends when the
consensus partition does not change.
}
\examples{
data(fingerprintMat)
data(targetMat)
L=list(fingerprintMat,targetMat)

MCF7_IVC=ConsensusClustering(List=L,type="data",distmeasure=c("tanimoto", "tanimoto"),
normalize=c(FALSE,FALSE),method=c(NULL,NULL),clust="agnes",linkage = c("flexible",
"flexible"),alpha=0.625,nrclusters=c(7,7),gap = FALSE, maxK = 15,
votingMethod="IVC",optimalk=7)
}
\references{
\insertRef{Nguyen2007}{IntClust}
}
