% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterVA5.get.symptoms.R
\name{getTopSymptoms}
\alias{getTopSymptoms}
\title{Get the symptoms with the largest conditional probability (symptom | cause) for causes assigned by InterVA-5.}
\usage{
getTopSymptoms(object, data, IDs = NULL, pretty = TRUE,
  includeAll = FALSE)
}
\arguments{
\item{object}{An interVA5 object (i.e., the results returned from the InterVA5() function).}

\item{data}{The input data that InterVA5 used to assign the causes of death.}

\item{IDs}{A vector that contains the IDs for each death (note that all of IDs are contained
in data$ID and object$ID).}

\item{pretty}{A logical indicating if you want the results in an easy-to-read format (default is `TRUE`)}

\item{includeAll}{A logical indicating if you want all of the symptoms included in the output
(even those which are absent or have a value of missing/no) (default is `FALSE` which only includes
symptoms that are present).}
}
\value{
\item{dist.cod}{A list of results for each death (organized by ID).  For each death, a list
is returned that includes the death's ID, the cause, and a vector of strings listing a symptom,
it if contributes to the cause assignment (if includeAll = TRUE), and the conditional probability of
observing the symptom given that the death is due to this cause.}
}
\description{
The function takes an interVA5 object and the data used to assign the causes, and returns the
the symptoms that contribute to the cause assignment (ranked in order of the conditional
probabilities of observing a symptom, given the death is due to that particular cause).
}
\examples{

\dontrun{
data(RandomVA5)
sample.output <- InterVA5(RandomVA5, HIV = "h", Malaria = "v", write=FALSE)
topSymptoms <- getTopSymptoms(object = sample.output,
                              data = RandomVA5,
                              IDs = sample.output$ID[1],
                              pretty = TRUE,
                              includeAll = FALSE)
}

}
\seealso{
\code{\link{InterVA5}, \link{getTopSymptoms}}
}
\author{
Jason Thomas, Zehang LI, Tyler McCormick, Sam Clark
}
\keyword{interVA}
