% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/titterington.R
\name{titterington}
\alias{titterington}
\title{Linear regression of X,Y,Z-variables with correlated errors}
\usage{
titterington(x, alpha = 0.05)
}
\arguments{
\item{x}{an \code{[nx9]} matrix with the following columns:
\code{X, sX,} \code{Y, sY,} \code{Z, sZ}, \code{rhoXY,}
\code{rhoXZ,} \code{rhoYZ}.}

\item{alpha}{cutoff value for confidence intervals}
}
\value{
A four-element list of vectors containing:

    \describe{
    \item{par}{4-element vector \code{c(a,b,A,B)} where \code{a} is
              the intercept of the \code{X-Y} regression, \code{b}
              is the slope of the \code{X-Y} regression, \code{A}
              is the intercept of the \code{X-Z} regression, and
              \code{B} is the slope of the \code{X-Z} regression.}

    \item{cov}{\code{[4x4]}-element covariance matrix of \code{par}}

    \item{mswd}{the mean square of the residuals (a.k.a `reduced
                Chi-square') statistic}

    \item{p.value}{p-value of a Chi-square test for linearity}

    \item{df}{the number of degrees of freedom for the
              Chi-square test (2\eqn{n}-4)}

    \item{tfact}{the \eqn{100(1-\alpha/2)\%} percentile of the
                 t-distribution with \eqn{(n-2k+1)} degrees of freedom}
}
}
\description{
Implements the maximum likelihood algorithm of Ludwig and
Titterington (1994) for linear regression of three dimensional data
with correlated uncertainties.
}
\details{
Ludwig and Titterington (1994)'s 3-dimensional linear regression
algorithm for data with correlated uncertainties is an extension of
the 2-dimensional algorithm by Titterington and Halliday (1979),
which itself is equivalent to the algorithm of York et al. (2004).
Given \eqn{n} triplets of (approximately) collinear measurements
\eqn{X_i}, \eqn{Y_i} and \eqn{Z_i} (for \eqn{1 \leq i \leq n}),
their uncertainties \eqn{s[X_i]}, \eqn{s[Y_i]} and \eqn{s[Z_i]},
and their covariances cov[\eqn{X_i,Y_i}], cov[\eqn{X_i,Z_i}] and
cov[\eqn{Y_i,Z_i}], the \code{titterington} function fits two
slopes and intercepts with their uncertainties. It computes the
MSWD as a measure of under/overdispersion.  Overdispersed datasets
(MSWD>1) can be dealt with in the same three ways that are
described in the documentation of the \code{\link{isochron}}
function.
}
\examples{
d <- matrix(c(0.1677,0.0047,1.105,0.014,0.782,0.015,0.24,0.51,0.33,
              0.2820,0.0064,1.081,0.013,0.798,0.015,0.26,0.63,0.32,
              0.3699,0.0076,1.038,0.011,0.819,0.015,0.27,0.69,0.30,
              0.4473,0.0087,1.051,0.011,0.812,0.015,0.27,0.73,0.30,
              0.5065,0.0095,1.049,0.010,0.842,0.015,0.27,0.76,0.29,
              0.5520,0.0100,1.039,0.010,0.862,0.015,0.27,0.78,0.28),
            nrow=6,ncol=9)
colnames(d) <- c('X','sX','Y','sY','Z','sZ','rXY','rXZ','rYZ')
titterington(d)
}
\references{
Ludwig, K.R. and Titterington, D.M., 1994. Calculation
of \eqn{^{230}}Th/U isochrons, ages, and errors. Geochimica et
Cosmochimica Acta, 58(22), pp.5031-5042.

Titterington, D.M. and Halliday, A.N., 1979. On the fitting of
parallel isochrons and the method of maximum likelihood. Chemical
Geology, 26(3), pp.183-195.

York, D., Evensen, N.M., Martinez, M.L. and De Basebe Delgado, J., 2004.
Unified equations for the slope, intercept, and standard
errors of the best straight line. American Journal of Physics,
72(3), pp.367-375.
}
\seealso{
\code{\link{york}}, \code{\link{isochron}}, \code{\link{ludwig}}
}
