/*
 * Decompiled with CFR 0.152.
 */
package j4r.lang.codetranslator;

import j4r.lang.J4RSystem;
import j4r.lang.reflect.ReflectUtility;
import j4r.multiprocess.JavaProcess;
import j4r.multiprocess.JavaProcessWrapper;
import j4r.net.server.BasicClient;
import j4r.net.server.JavaLocalGatewayServer;
import j4r.net.server.ServerConfiguration;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class REnvironment
extends ConcurrentHashMap<Integer, Object> {
    private static final String FIRSTCALL = "-firstcall";
    public static final String MainSplitter = "/;";
    public static final String SubSplitter = "/,";
    private static final String R_NUMERIC_TOKEN = "nu";
    private static final String R_INTEGER_TOKEN = "in";
    private static final String R_LOGICAL_TOKEN = "lo";
    private static final String R_CHARACTER_TOKEN = "ch";
    private static final String R_JAVA_OBJECT_TOKEN = "JO";
    private static final String R_JAVA_LIST_TOKEN = "JL";
    private static final Map<String, Class<?>> PrimitiveTypeMap = new HashMap();
    private static String ConstructCode;
    private static String ConstructNullArrayCode;
    private static String ConstructNullCode;
    private static String ConstructArrayCode;
    private static String MethodCode;
    private static String ClassInfo;
    private static String FlushInstances;
    private static String InternalMapSize;
    private static String FieldCode;
    private static final Random RANDOM;

    static {
        PrimitiveTypeMap.put("integer", Integer.TYPE);
        PrimitiveTypeMap.put("character", String.class);
        PrimitiveTypeMap.put("numeric", Double.TYPE);
        PrimitiveTypeMap.put("logical", Boolean.TYPE);
        PrimitiveTypeMap.put("long", Long.TYPE);
        PrimitiveTypeMap.put("float", Float.TYPE);
        ConstructCode = "co";
        ConstructNullArrayCode = "cona";
        ConstructNullCode = "conu";
        ConstructArrayCode = "coar";
        MethodCode = "method";
        ClassInfo = "cli";
        FlushInstances = "flush";
        InternalMapSize = "size";
        FieldCode = "field";
        RANDOM = new Random();
    }

    public Object processCode(String request) throws Exception {
        String[] requestStrings = request.split(MainSplitter);
        if (requestStrings[0].startsWith(ConstructCode)) {
            return this.createObjectFromRequestStrings(requestStrings);
        }
        if (requestStrings[0].equals(MethodCode)) {
            return this.processMethod(requestStrings);
        }
        if (requestStrings[0].equals(FieldCode)) {
            return this.processField(requestStrings);
        }
        if (requestStrings[0].equals(ClassInfo)) {
            return this.getClassInfo(requestStrings);
        }
        if (requestStrings[0].equals(FlushInstances)) {
            return this.flushTheseObjects(requestStrings);
        }
        if (requestStrings[0].equals(InternalMapSize)) {
            return this.getInternalMapSize();
        }
        try {
            return BasicClient.ClientRequest.valueOf(request);
        }
        catch (Exception e) {
            throw new InvalidParameterException("Request unknown! " + request);
        }
    }

    private Object getClassInfo(String[] requestStrings) throws ClassNotFoundException {
        Field[] fields;
        boolean isArray;
        Class clazz;
        String classname = requestStrings[1];
        if (classname.startsWith("[")) {
            clazz = Object.class;
            isArray = true;
        } else {
            clazz = Class.forName(classname);
            isArray = false;
        }
        Method[] methods = clazz.getMethods();
        JavaObjectList outputList = new JavaObjectList();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            this.registerMethodOutput(m.getName(), outputList);
            ++n2;
        }
        if (isArray) {
            this.registerMethodOutput("clone", outputList);
        }
        this.registerMethodOutput("endOfMethods", outputList);
        Field[] fieldArray = fields = clazz.getFields();
        int n3 = fields.length;
        n = 0;
        while (n < n3) {
            Field f = fieldArray[n];
            this.registerMethodOutput(f.getName(), outputList);
            ++n;
        }
        if (isArray) {
            this.registerMethodOutput("length", outputList);
        }
        if (outputList.isEmpty()) {
            return null;
        }
        if (outputList.size() == 1) {
            return outputList.get(0);
        }
        return outputList;
    }

    private Object flushTheseObjects(String[] requestStrings) {
        String prefix = "java.objecthashcode";
        if (requestStrings[1].startsWith(prefix)) {
            String[] newArgs = requestStrings[1].substring(prefix.length()).split(SubSplitter);
            int i = 0;
            while (i < newArgs.length) {
                int hashcodeForThisJavaObject = Integer.parseInt(newArgs[i]);
                if (this.containsKey(hashcodeForThisJavaObject)) {
                    this.remove(hashcodeForThisJavaObject);
                }
                ++i;
            }
        }
        return null;
    }

    private JavaObjectList getInternalMapSize() {
        JavaObjectList outputList = new JavaObjectList();
        this.registerMethodOutput(this.size(), outputList);
        return outputList;
    }

    private List<ParameterWrapper> findObjectInEnvironment(String string) {
        ArrayList<ParameterWrapper> wrappers = new ArrayList<ParameterWrapper>();
        String prefix = "java.objecthashcode";
        if (string.startsWith(prefix)) {
            String[] newArgs = string.substring(prefix.length()).split(SubSplitter);
            int i = 0;
            while (i < newArgs.length) {
                Class<?> type;
                Object value;
                int hashcodeForThisJavaObject = Integer.parseInt(newArgs[i]);
                if (this.containsKey(hashcodeForThisJavaObject)) {
                    value = this.get(hashcodeForThisJavaObject);
                    if (value instanceof NullWrapper) {
                        type = ((NullWrapper)value).type;
                        value = null;
                    } else {
                        type = value.getClass();
                    }
                } else {
                    throw new InvalidParameterException("This object does not exist: " + string);
                }
                wrappers.add(new ParameterWrapper(type, value));
                ++i;
            }
        }
        return wrappers;
    }

    private Object processField(String[] requestStrings) throws Exception {
        Object caller;
        Class<?> clazz = null;
        List<ParameterWrapper> wrappers = null;
        boolean lookingForStaticMethod = false;
        if (requestStrings[1].startsWith("java.object")) {
            wrappers = this.findObjectInEnvironment(requestStrings[1]);
            caller = this.getCallerAmongWrappers(wrappers);
            clazz = caller.getClass();
        } else {
            wrappers = this.createFromPrimitiveClass(this.getPrimitiveClass(requestStrings[1]), requestStrings[1]);
            caller = wrappers.get(0);
            if (wrappers.size() == 1 && ((ParameterWrapper)caller).type.equals(String.class)) {
                try {
                    String className = ((ParameterWrapper)caller).value.toString();
                    clazz = Class.forName(className);
                    lookingForStaticMethod = true;
                    wrappers = new ArrayList<ParameterWrapper>();
                    wrappers.add(new ParameterWrapper(clazz, null));
                }
                catch (ClassNotFoundException e) {
                    clazz = ReflectUtility.PrimitiveToJavaWrapperMap.get(((ParameterWrapper)caller).type);
                }
            } else {
                clazz = ReflectUtility.PrimitiveToJavaWrapperMap.get(((ParameterWrapper)caller).type);
            }
        }
        List[] outputLists = this.marshallParameters(requestStrings, 3);
        List parameterTypes = outputLists[0];
        if (parameterTypes.size() > 1) {
            throw new InvalidParameterException("While setting a field, there cannot be more than a single argument to the function!");
        }
        ParameterList parameters = (ParameterList)outputLists[1];
        String fieldName = requestStrings[2];
        boolean isArrayLengthCalled = clazz.getName().startsWith("[") && parameters.isEmpty() && fieldName.equals("length");
        Field field = null;
        if (!isArrayLengthCalled) {
            try {
                field = clazz.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if (clazz.equals(String.class)) {
                    throw new NoSuchFieldException(String.valueOf(e.getMessage()) + " - NOTE: the source was treated as a String object!");
                }
                throw e;
            }
            if (lookingForStaticMethod && !Modifier.isStatic(field.getModifiers())) {
                throw new InvalidParameterException("The field is not a static field!");
            }
        }
        JavaObjectList outputList = new JavaObjectList();
        if (parameters.isEmpty()) {
            int j = 0;
            while (j < wrappers.size()) {
                Object result = isArrayLengthCalled ? Integer.valueOf(Array.getLength(wrappers.get((int)j).value)) : field.get(wrappers.get((int)j).value);
                this.registerMethodOutput(result, outputList);
                ++j;
            }
        } else {
            if (wrappers.size() > 1 && parameters.getInnerSize() > 1 && wrappers.size() != parameters.getInnerSize()) {
                throw new InvalidParameterException("The length of the java.arraylist object is different of the length of the vectors in the parameters!");
            }
            int maxSize = Math.max(wrappers.size(), parameters.getInnerSize());
            int i = 0;
            while (i < maxSize) {
                int j = i;
                if (parameters.getInnerSize() == 1) {
                    j = 0;
                }
                int k = i;
                if (wrappers.size() == 1) {
                    k = 0;
                }
                field.set(wrappers.get((int)k).value, parameters.getParameterArray(j)[0]);
                ++i;
            }
        }
        if (outputList.isEmpty()) {
            return null;
        }
        if (outputList.size() == 1) {
            return outputList.get(0);
        }
        return outputList;
    }

    private static int generateSecurityKey() {
        return RANDOM.nextInt();
    }

    private Object processMethod(String[] requestStrings) throws Exception {
        Method met;
        Object caller;
        Class<?> clazz = null;
        List<ParameterWrapper> wrappers = null;
        boolean lookingForStaticMethod = false;
        if (requestStrings[1].startsWith("java.object")) {
            wrappers = this.findObjectInEnvironment(requestStrings[1]);
            caller = this.getCallerAmongWrappers(wrappers);
            clazz = caller.getClass();
        } else {
            wrappers = this.createFromPrimitiveClass(this.getPrimitiveClass(requestStrings[1]), requestStrings[1]);
            caller = wrappers.get(0);
            if (wrappers.size() == 1 && ((ParameterWrapper)caller).type.equals(String.class)) {
                try {
                    String className = ((ParameterWrapper)caller).value.toString();
                    clazz = Class.forName(className);
                    lookingForStaticMethod = true;
                    wrappers = new ArrayList<ParameterWrapper>();
                    wrappers.add(new ParameterWrapper(clazz, null));
                }
                catch (ClassNotFoundException e) {
                    clazz = ReflectUtility.PrimitiveToJavaWrapperMap.get(((ParameterWrapper)caller).type);
                }
            } else {
                clazz = ReflectUtility.PrimitiveToJavaWrapperMap.get(((ParameterWrapper)caller).type);
            }
        }
        List[] outputLists = this.marshallParameters(requestStrings, 3);
        List parameterTypes = outputLists[0];
        ParameterList parameters = (ParameterList)outputLists[1];
        String methodName = requestStrings[2];
        try {
            met = parameters.isEmpty() ? clazz.getMethod(methodName, null) : clazz.getMethod(methodName, parameterTypes.toArray(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            if (parameters.isEmpty()) {
                throw e;
            }
            met = this.findNearestMethod(clazz, methodName, parameterTypes);
        }
        if (lookingForStaticMethod && !Modifier.isStatic(met.getModifiers())) {
            throw new InvalidParameterException("The method is not a static method!");
        }
        JavaObjectList outputList = new JavaObjectList();
        if (parameters.isEmpty()) {
            int j = 0;
            while (j < wrappers.size()) {
                Object result = met.invoke(wrappers.get((int)j).value, null);
                this.registerMethodOutput(result, outputList);
                ++j;
            }
        } else {
            if (wrappers.size() > 1 && parameters.getInnerSize() > 1 && wrappers.size() != parameters.getInnerSize()) {
                throw new InvalidParameterException("The length of the java.arraylist object is different of the length of the vectors in the parameters!");
            }
            int maxSize = Math.max(wrappers.size(), parameters.getInnerSize());
            int i = 0;
            while (i < maxSize) {
                int j = i;
                if (parameters.getInnerSize() == 1) {
                    j = 0;
                }
                int k = i;
                if (wrappers.size() == 1) {
                    k = 0;
                }
                Object result = met.invoke(wrappers.get((int)k).value, parameters.getParameterArray(j));
                this.registerMethodOutput(result, outputList);
                ++i;
            }
        }
        if (outputList.isEmpty()) {
            return null;
        }
        if (outputList.size() == 1) {
            return outputList.get(0);
        }
        return outputList;
    }

    private Object getCallerAmongWrappers(List<ParameterWrapper> wrappers) {
        if (wrappers == null || wrappers.isEmpty()) {
            return null;
        }
        Object higherLevelObject = null;
        for (ParameterWrapper wrapper : wrappers) {
            if (higherLevelObject == null) {
                higherLevelObject = wrapper.value;
                continue;
            }
            Object newValue = wrapper.value;
            if (!newValue.getClass().isAssignableFrom(higherLevelObject.getClass())) continue;
            higherLevelObject = newValue;
        }
        return higherLevelObject;
    }

    private Method findNearestMethod(Class clazz, String methodName, List<Class<?>> parameterTypes) throws NoSuchMethodException {
        Method[] methods = clazz.getMethods();
        ArrayList<MethodWrapper> possibleMatches = new ArrayList<MethodWrapper>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] classes;
            double score;
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && (score = this.doParameterTypesMatch(classes = method.getParameterTypes(), parameterTypes.toArray(new Class[0]))) >= 0.0) {
                possibleMatches.add(new MethodWrapper(score, method));
            }
            ++n2;
        }
        if (possibleMatches.isEmpty()) {
            throw new NoSuchMethodException("Method " + methodName + " cannot be found in the class " + clazz.getSimpleName());
        }
        Collections.sort(possibleMatches);
        return ((MethodWrapper)possibleMatches.get((int)0)).method;
    }

    private void registerMethodOutput(Object result, JavaObjectList outputList) {
        if (result != null) {
            if (!ReflectUtility.JavaWrapperToPrimitiveMap.containsKey(result.getClass())) {
                this.put(System.identityHashCode(result), result);
            }
            outputList.add(new ParameterWrapper(result.getClass(), result));
        }
    }

    private double doParameterTypesMatch(Class<?>[] ref, Class<?>[] obs) {
        if (ref == null && obs == null) {
            return 0.0;
        }
        if (ref != null && obs != null && ref.length == obs.length) {
            double sumScores = 0.0;
            int i = 0;
            while (i < ref.length) {
                double score = this.isAssignableOfThisClass(ref[i], obs[i]);
                if (score == -1.0) {
                    return -1.0;
                }
                sumScores += score;
                ++i;
            }
            return sumScores;
        }
        return -1.0;
    }

    private boolean implementThisClassAsAnInterface(Class<?> refcl1, Class<?> cl) {
        Class<?>[] interfaces;
        if (ReflectUtility.JavaWrapperToPrimitiveMap.containsKey(refcl1) && cl.equals(ReflectUtility.JavaWrapperToPrimitiveMap.get(refcl1))) {
            return true;
        }
        if (ReflectUtility.PrimitiveToJavaWrapperMap.containsKey(refcl1) && cl.equals(ReflectUtility.PrimitiveToJavaWrapperMap.get(refcl1))) {
            return true;
        }
        Class<?>[] classArray = interfaces = cl.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inter = classArray[n2];
            if (inter.getName().equals(refcl1.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private double isAssignableOfThisClass(Class<?> refcl1, Class<?> cl2) {
        int degree = 0;
        Class<Object> cl = cl2;
        boolean isInterfaceMatching = this.implementThisClassAsAnInterface(refcl1, cl);
        while (!(refcl1.getName().equals(cl.getName()) || isInterfaceMatching || cl.getName().equals("java.lang.Object"))) {
            cl = cl.isPrimitive() ? Object.class : cl.getSuperclass();
            isInterfaceMatching = this.implementThisClassAsAnInterface(refcl1, cl);
            ++degree;
        }
        if (refcl1.getName().equals(cl.getName())) {
            return degree;
        }
        if (isInterfaceMatching) {
            return (double)degree + 0.5;
        }
        return -1.0;
    }

    private Object createObjectFromRequestStrings(String[] requestStrings) throws Exception {
        JavaObjectList outputList = new JavaObjectList();
        boolean isNull = requestStrings[0].equals(ConstructNullCode);
        boolean isArray = requestStrings[0].equals(ConstructArrayCode);
        boolean isNullArray = requestStrings[0].equals(ConstructNullArrayCode);
        String className = requestStrings[1];
        Class<?> clazz = ReflectUtility.PrimitiveTypeMap.containsKey(className) ? ReflectUtility.PrimitiveTypeMap.get(className) : Class.forName(className);
        List[] outputLists = this.marshallParameters(requestStrings, 2);
        List parameterTypes = outputLists[0];
        ParameterList parameters = (ParameterList)outputLists[1];
        if (parameters.isEmpty()) {
            Object newInstance = isNull ? new NullWrapper(clazz) : this.getNewInstance(isArray, clazz, null, null);
            this.registerNewInstance(newInstance, outputList);
        } else {
            int i = 0;
            while (i < parameters.getInnerSize()) {
                Object newInstance;
                if (isNull) {
                    newInstance = new NullWrapper(clazz);
                } else if (isNullArray) {
                    Object fakeInstance = this.getNewInstance(true, clazz, parameterTypes.toArray(new Class[0]), parameters.getParameterArray(i));
                    newInstance = new NullWrapper(fakeInstance.getClass());
                } else {
                    newInstance = this.getNewInstance(isArray, clazz, parameterTypes.toArray(new Class[0]), parameters.getParameterArray(i));
                }
                this.registerNewInstance(newInstance, outputList);
                ++i;
            }
        }
        if (outputList.isEmpty()) {
            return null;
        }
        if (outputList.size() == 1) {
            return outputList.get(0);
        }
        return outputList;
    }

    private Object getNewInstance(boolean isArray, Class clazz, Class[] paramTypes, Object[] paramValues) throws Exception {
        if (paramTypes == null) {
            if (isArray) {
                throw new InvalidParameterException("Constructing an array requires at least one parameter, namely an integer that determines the size of the array!");
            }
            return clazz.newInstance();
        }
        if (isArray) {
            int[] dimensions = (int[])ReflectUtility.convertArrayType(paramValues, Integer.TYPE);
            return Array.newInstance(clazz, dimensions);
        }
        if (clazz.isEnum()) {
            Method met = clazz.getMethod("valueOf", String.class);
            return met.invoke(null, paramValues[0].toString());
        }
        Constructor constructor = clazz.getConstructor(paramTypes);
        return constructor.newInstance(paramValues);
    }

    private void registerNewInstance(Object newInstance, JavaObjectList outputList) {
        this.put(System.identityHashCode(newInstance), newInstance);
        outputList.add(new ParameterWrapper(newInstance.getClass(), newInstance));
    }

    private List[] marshallParameters(String[] args, int start) {
        List[] outputLists = new List[2];
        ArrayList parameterTypes = new ArrayList();
        ParameterList parameters = new ParameterList();
        outputLists[0] = parameterTypes;
        outputLists[1] = parameters;
        int i = start;
        while (i < args.length) {
            String primitiveClassIfAny = this.getPrimitiveClass(args[i]);
            List<ParameterWrapper> subparametersList = primitiveClassIfAny != null ? this.createFromPrimitiveClass(primitiveClassIfAny, args[i]) : this.findObjectInEnvironment(args[i]);
            parameterTypes.add(subparametersList.get((int)0).type);
            parameters.add(subparametersList);
            ++i;
        }
        return outputLists;
    }

    private String getPrimitiveClass(String string) {
        for (String key : PrimitiveTypeMap.keySet()) {
            if (!string.startsWith(key)) continue;
            return key;
        }
        return null;
    }

    private List<ParameterWrapper> createFromPrimitiveClass(String primitiveTypeClass, String args) {
        String[] newArgs;
        ArrayList<ParameterWrapper> wrappers = new ArrayList<ParameterWrapper>();
        String[] stringArray = newArgs = args.substring(primitiveTypeClass.length()).split(SubSplitter);
        int n = newArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (primitiveTypeClass == "character") {
                wrappers.add(new ParameterWrapper(String.class, value));
            } else if (primitiveTypeClass == "numeric") {
                wrappers.add(new ParameterWrapper(Double.TYPE, Double.parseDouble(value)));
            } else if (primitiveTypeClass == "integer") {
                wrappers.add(new ParameterWrapper(Integer.TYPE, Integer.parseInt(value)));
            } else if (primitiveTypeClass == "logical") {
                String subString = value.toLowerCase();
                wrappers.add(new ParameterWrapper(Boolean.TYPE, (boolean)Boolean.valueOf(subString)));
            } else if (primitiveTypeClass == "long") {
                wrappers.add(new ParameterWrapper(Long.TYPE, Long.parseLong(value)));
            } else if (primitiveTypeClass == "float") {
                wrappers.add(new ParameterWrapper(Float.TYPE, Float.valueOf(Float.parseFloat(value))));
            }
            ++n2;
        }
        return wrappers;
    }

    public static void main(String[] args) throws Exception {
        JavaLocalGatewayServer server = null;
        try {
            int[] listeningPorts;
            String portStr;
            List<String> arguments = J4RSystem.setClassicalOptions(args);
            String firstCall = J4RSystem.retrieveArgument(FIRSTCALL, arguments);
            if (firstCall != null && firstCall.toLowerCase().trim().equals("true")) {
                String port;
                ArrayList<String> newCommands = new ArrayList<String>();
                newCommands.add(REnvironment.class.getName());
                String architecture = J4RSystem.getJavaArchitecture();
                String classPath = architecture.equals("32") ? "j4r_x86.jar" : "j4r.jar";
                String extensionPath = J4RSystem.retrieveArgument("-ext", arguments);
                if (extensionPath != null && new File(extensionPath).exists()) {
                    String classPathSeparator = ":";
                    if (J4RSystem.isRunningOnWindows()) {
                        classPathSeparator = ";";
                    }
                    classPath = String.valueOf(classPath) + classPathSeparator + extensionPath;
                }
                if ((port = J4RSystem.retrieveArgument("-ports", arguments)) != null) {
                    String[] p = port.split(":");
                    int i = 0;
                    while (i < p.length) {
                        if (Integer.parseInt(p[i]) < 0) {
                            throw new InvalidParameterException("Port numbers should be integers equal to or greater than 0!");
                        }
                        ++i;
                    }
                    newCommands.add("-ports");
                    newCommands.add(port);
                } else {
                    String nbPorts = J4RSystem.retrieveArgument("-nbports", arguments);
                    if (nbPorts == null) {
                        newCommands.add("-nbports");
                        newCommands.add("1");
                    } else {
                        newCommands.add("-nbports");
                        newCommands.add(nbPorts);
                    }
                }
                String wd = J4RSystem.retrieveArgument("-wd", arguments);
                newCommands.add("-wd");
                newCommands.add(wd);
                String memorySizeStr = J4RSystem.retrieveArgument("-mem", arguments);
                Integer memorySize = null;
                if (memorySizeStr != null) {
                    try {
                        memorySize = Integer.parseInt(memorySizeStr);
                    }
                    catch (Exception e) {
                        memorySize = null;
                    }
                }
                File jarFile = new File(REnvironment.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                File rootPath = jarFile.getParentFile();
                JavaProcessWrapper rGatewayProcessWrapper = new JavaProcessWrapper("Java server", newCommands, rootPath);
                Runtime.getRuntime().addShutdownHook(new InternalShutDownHook(rGatewayProcessWrapper));
                JavaProcess rGatewayProcess = rGatewayProcessWrapper.getInternalProcess();
                rGatewayProcess.setClassPath(classPath);
                if (memorySize != null) {
                    rGatewayProcess.setJVMMemory(memorySize);
                }
                if (J4RSystem.isCurrentJVMLaterThanThisVersion("1.8")) {
                    rGatewayProcess.setOpenModuleForVersionsLaterThan8Enabled(true);
                }
                rGatewayProcessWrapper.run();
                System.exit(0);
            }
            if ((portStr = J4RSystem.retrieveArgument("-ports", arguments)) != null) {
                listeningPorts = REnvironment.parsePorts(portStr);
            } else {
                String nbPortsStr = J4RSystem.retrieveArgument("-nbports", arguments);
                int nbPorts = nbPortsStr == null ? 1 : Integer.parseInt(nbPortsStr);
                listeningPorts = new int[nbPorts];
            }
            String backdoorportStr = J4RSystem.retrieveArgument("-backdoorport", arguments);
            int[] backdoorports = backdoorportStr != null ? REnvironment.parsePorts(backdoorportStr) : new int[2];
            String debugMode = J4RSystem.retrieveArgument("-debug", arguments);
            int key = debugMode != null && debugMode.trim().toLowerCase().equals("on") ? 1000000 : REnvironment.generateSecurityKey();
            ServerConfiguration conf = new ServerConfiguration(listeningPorts, backdoorports, key, J4RSystem.retrieveArgument("-wd", arguments));
            server = new JavaLocalGatewayServer(conf, new REnvironment());
            server.startApplication();
        }
        catch (Exception e) {
            System.err.println("Error:" + e.getMessage());
            System.exit(1);
        }
    }

    private static int[] parsePorts(String str) {
        String[] p = str.split(":");
        int[] ports = new int[p.length];
        int i = 0;
        while (i < p.length) {
            ports[i] = Integer.parseInt(p[i]);
            ++i;
        }
        return ports;
    }

    static class InternalShutDownHook
    extends Thread {
        final JavaProcessWrapper rGatewayProcessWrapper;

        InternalShutDownHook(JavaProcessWrapper rGatewayProcessWrapper) {
            this.rGatewayProcessWrapper = rGatewayProcessWrapper;
        }

        @Override
        public void run() {
            this.rGatewayProcessWrapper.cancel();
        }
    }

    static class JavaObjectList
    extends ArrayList<ParameterWrapper> {
        JavaObjectList() {
        }

        @Override
        public String toString() {
            String output = "JL/;";
            for (ParameterWrapper obj : this) {
                String toBeAdded = obj.toString();
                if (toBeAdded.startsWith("JO/;")) {
                    toBeAdded = toBeAdded.substring("JO/;".length());
                }
                output = String.valueOf(output) + toBeAdded + REnvironment.SubSplitter;
            }
            return output;
        }
    }

    static class MethodWrapper
    implements Comparable<MethodWrapper> {
        final double score;
        final Method method;

        MethodWrapper(double score, Method method) {
            this.score = score;
            this.method = method;
        }

        @Override
        public int compareTo(MethodWrapper o) {
            if (this.score < o.score) {
                return -1;
            }
            if (this.score == o.score) {
                return 0;
            }
            return 1;
        }
    }

    private class NullWrapper {
        final Class<?> type;

        private NullWrapper(Class<?> type) {
            this.type = type;
        }
    }

    static class ParameterList
    extends ArrayList<List<ParameterWrapper>> {
        ParameterList() {
        }

        int getInnerSize() {
            int currentSize = 0;
            int i = 0;
            while (i < this.size()) {
                if (((List)this.get(i)).size() > currentSize) {
                    currentSize = ((List)this.get(i)).size();
                }
                ++i;
            }
            return currentSize;
        }

        Object[] getParameterArray(int i) {
            int currentSize = this.getInnerSize();
            if (i > currentSize) {
                throw new InvalidParameterException("Inconsistent parameter setup!");
            }
            Object[] parms = new Object[this.size()];
            int j = 0;
            while (j < this.size()) {
                parms[j] = ((List)this.get(j)).size() == 1 ? ((ParameterWrapper)((List)this.get((int)j)).get((int)0)).value : ((ParameterWrapper)((List)this.get((int)j)).get((int)i)).value;
                ++j;
            }
            return parms;
        }
    }

    private class ParameterWrapper {
        final Class<?> type;
        final Object value;

        private ParameterWrapper(Class<?> type, Object value) {
            this.type = type;
            this.value = value;
        }

        public String toString() {
            if (ReflectUtility.JavaWrapperToPrimitiveMap.containsKey(this.type)) {
                if (this.type.equals(Double.class) || this.type.equals(Float.class)) {
                    return REnvironment.R_NUMERIC_TOKEN + ((Number)this.value).toString();
                }
                if (this.type.equals(Integer.class) || this.type.equals(Long.class)) {
                    return REnvironment.R_INTEGER_TOKEN + ((Number)this.value).toString();
                }
                if (this.type.equals(Boolean.class)) {
                    return REnvironment.R_LOGICAL_TOKEN + ((Boolean)this.value).toString();
                }
                return REnvironment.R_CHARACTER_TOKEN + this.value.toString();
            }
            String className = this.type.getName();
            if (className.endsWith(";")) {
                className = className.substring(0, className.length() - 1);
            } else if (className.endsWith(REnvironment.MainSplitter)) {
                className = className.substring(0, className.length() - REnvironment.MainSplitter.length());
            }
            return "JO/;" + className + "@" + System.identityHashCode(this.value);
        }
    }
}

