\name{ttsCaret}
\alias{ttsCaret}

\encoding{latin1}

\title{Train time series by \code{caret} and produce two types of time series forecasts: static and recursive}

\description{
It generates both the static and recursive time series plots of machine learning prediction object generated by package \code{caret}.
}
\usage{
ttsCaret(y,x=NULL,method,train.end, arOrder=2,xregOrder=0,type,tuneLength =10)
}

\arguments{
  \item{y}{
The time series of target variable, or the dependent variable, with \code{timeSeries} format.
}

  \item{x}{ The time series of input variables, or the independent variables, with \code{timeSeries} format.
}

  \item{method}{The train_model_list of \code{caret}. While using this, make sure that the method allows regression. Methods in c("svm","rf","rpart","gamboost","BstLm","bstSm","blackboost") are feasible.

}


  \item{train.end}{The end date of training data, must be specificed.The default dates of train.start and test.end are the start and the end of input data; and the test.start is the 1-period next of train.end.

}


\item{arOrder}{The autoregressive order of the target variable, which may be sequentially specifed like arOrder=1:5; or discontinuous lags like arOrder=c(1,3,5); zero is not allowed.

}

\item{xregOrder}{The distributed lag structure of the input variables, which may be sequentially specifed like xregOrder=0:5; or discontinuous lags like xregOrder=c(0,3,5); zero is allowed since contemporaneous correlation is allowed.

}

\item{type}{The additional input variables. We have four selection:\cr "none"=no other variables,\cr "trend"=inclusion of time dummy, \cr "season"=inclusion of seasonal dummies, \cr "both"=inclusion of both trend and season. No default.

}

\item{tuneLength}{The same as the length specified in  train function of package \code{caret}.

}


}


\details{

This function calls the train function of package \code{caret} to execute estimation. When execution finished, we compute two types of time series forecasts: static and recursive.
}



\value{

  \item{staticData}{Two-column data with actual target series and the static forecasting series}
  \item{recursiveData}{Two-column data with actual target series and the recursive forecasting series}
  \item{staticF}{The static forecasting series of the period of test data}
  \item{recursiveF}{The recursive forecasting series of the period of test data}
  \item{static.Accuracy}{The accuracy measures of \code{forecast} of static forecasting series}
  \item{recursive.Accuracy}{The accuracy measures of \code{forecast} of recursive forecasting series}
  \item{method}{The train_model_list used in ttsCaret}
  \item{data}{The data used by arOrder, xregOrder, and type}

}


\author{
Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.

}

\examples{
# Cross-validation takes time, example below is commented.
#library(timeSeries)
data(macrodata)
Y <- macrodata[,"unrate"]
X <- macrodata[,-1]
train.end <- "2008-12-01"
#results <- ttsCaret(y=Y, x=X, method="svm", train.end,arOrder=c(2,3),
#          xregOrder=c(1,2), type="none",tuneLength =10)
#head(results$data)
#results$static.Accuracy
#results$recursive.Accuracy

}

