\name{ttsPlot}
\alias{ttsPlot}

\encoding{latin1}

\title{Plot time series prediction performance}

\description{
It generates  both the static and recursive time series plots of machine learning prediction object generated by package \code{caret}.
}
\usage{
ttsPlot(object,
which,
vertical,
main=NULL,
xlab="Time",
ylab="Value",
col1="black",
col2="red",
type="o",
ylim=NULL)
}

\arguments{
  \item{object}{
Object of tts object.
}

  \item{which}{ If which="static", it plots the static prediction of insample model fit; if which="recursive", it plots the recursive prediction of insample model fit
}

  \item{vertical}{The number of veritcal time line of seperating training and testing regimes.

}

  \item{main}{Text appeared as main in R plot.

}

  \item{xlab}{Text appeared as main in R plot, default is "time".

}


  \item{ylab}{Text appeared as main in R plot, default is "Value".

}


  \item{col1}{Line color appeared as main in R plot, default is "black".

}

  \item{col2}{Prediction line color appeared as main in R plot, default is "red".

}
  \item{type}{Line type appeared as main in R plot, default is "o.

}

  \item{ylim}{ylim appeared as main in R plot, default is range of object data value.

}


}


\details{

This function handles object generated by ttsCaret and plots two time series data: the actual series and model's forecast.
}



\value{
Returns a time series plot.
}


\author{
Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.

}

\examples{
# Cross-validation takes time, example below is commented.
#library(timeSeries)
data(macrodata)
Y <- macrodata[,"unrate"]
X <- macrodata[,-1]
train.end <- "2008-12-01"
#results  <- ttsCaret(y=Y, x=X, method="svm", train.end,arOrder=c(2,3),
#          xregOrder=c(1,2), type="none",tuneLength =10)
#ttsPlot(results,which=c("static","recursive")[2],vertical=t0)
}

