/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.SyntaxDocument;
import org.rosuda.JGR.toolkit.TextTransferHandler;
import org.rosuda.JGR.util.ErrorMsg;

public class SyntaxArea
extends JTextPane
implements CaretListener,
DropTargetListener {
    private final HighlightPainter ParanthesisHighlightMissing = new HighlightPainter(JGRPrefs.ERRORColor);
    private final HighlightPainter ParanthesisHighlight = new HighlightPainter(JGRPrefs.BRACKETHighLight);
    private boolean wrap = true;

    public SyntaxArea() {
        this.setContentType("text/rtf");
        this.setDocument(new SyntaxDocument());
        if (FontTracker.current == null) {
            FontTracker.current = new FontTracker();
        }
        FontTracker.current.add(this);
        this.addCaretListener(this);
        this.setTransferHandler(new TextTransferHandler());
        this.setDragEnabled(true);
    }

    public void append(String string) {
        this.append(string, null);
    }

    public void append(String string, AttributeSet attributeSet) {
        try {
            Document document = this.getDocument();
            document.insertString(document.getLength(), string, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void insertAt(int n, String string) {
        try {
            Document document = this.getDocument();
            document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getText() {
        try {
            Document document = this.getDocument();
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String getText(int n, int n2) {
        try {
            Document document = this.getDocument();
            return document.getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public void setText(String string) {
        try {
            Document document = this.getDocument();
            document.remove(0, document.getLength());
            document.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void cut() {
        this.removeCaretListener(this);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.getSelectedText()), null);
        this.replaceSelection("");
        this.addCaretListener(this);
    }

    public void copy() {
        this.removeCaretListener(this);
        super.copy();
        this.addCaretListener(this);
    }

    public void paste() {
        this.removeCaretListener(this);
        try {
            SyntaxDocument syntaxDocument = (SyntaxDocument)this.getDocument();
            if (this.isEditable() && this.isEnabled()) {
                int n = this.getSelectionStart();
                int n2 = this.getSelectionEnd();
                if (n != -1 && n2 != -1) {
                    syntaxDocument.remove(n, n2 - n);
                }
                syntaxDocument.insertStringWithoutWhiteSpace(this.getCaretPosition(), Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor).toString(), null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addCaretListener(this);
    }

    public int getLineCount() {
        Element element = this.getDocument().getDefaultRootElement();
        return element.getElementCount();
    }

    public int getLineStartOffset(int n) throws BadLocationException {
        int n2 = this.getLineCount();
        if (n < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (n >= n2) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element element = this.getDocument().getDefaultRootElement();
        Element element2 = element.getElement(n);
        return element2.getStartOffset();
    }

    public int getLineEndOffset(int n) throws BadLocationException {
        int n2 = this.getLineCount();
        if (n < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (n >= n2) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element element = this.getDocument().getDefaultRootElement();
        Element element2 = element.getElement(n);
        int n3 = element2.getEndOffset();
        return n == n2 - 1 ? n3 - 1 : n3;
    }

    public int getLineOfOffset(int n) throws BadLocationException {
        Document document = this.getDocument();
        if (n < 0) {
            throw new BadLocationException("Can't translate offset to line", -1);
        }
        if (n > document.getLength()) {
            throw new BadLocationException("Can't translate offset to line", document.getLength() + 1);
        }
        Element element = this.getDocument().getDefaultRootElement();
        return element.getElementIndex(n);
    }

    public void setWordWrap(boolean bl) {
        this.wrap = bl;
    }

    public boolean getWordWrap() {
        return this.wrap;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (!this.wrap) {
            Container container = this.getParent();
            TextUI textUI = this.getUI();
            int n = textUI.getPreferredSize((JComponent)this).width;
            int n2 = container.getSize().width;
            boolean bl = container != null ? textUI.getPreferredSize((JComponent)this).width < container.getSize().width : true;
            return bl;
        }
        return super.getScrollableTracksViewportWidth();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.wrap) {
            super.setBounds(n, n2, n3, n4);
        } else {
            Dimension dimension = this.getPreferredSize();
            super.setBounds(n, n2, Math.max(dimension.width, n3), Math.max(dimension.height, n4));
        }
    }

    public boolean isEscaped(int n) {
        boolean bl = false;
        try {
            bl = this.lastChar(n - 1, "\\");
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean lastChar(int n, String string) {
        if (n == 0) {
            return false;
        }
        return this.getText(n - 1, 1) != null && this.getText(n - 1, 1).equals(string);
    }

    public void highlightParanthesisForward(String string, int n) throws BadLocationException {
        int n2 = n;
        int n3 = this.getText().length();
        String string2 = null;
        if (string.equals("{")) {
            string2 = "}";
        }
        if (string.equals("(")) {
            string2 = ")";
        }
        if (string.equals("[")) {
            string2 = "]";
        }
        if (string2 == null) {
            return;
        }
        String string3 = null;
        int n4 = 1;
        int n5 = this.getLineOfOffset(n2);
        int n6 = this.getLineStartOffset(n5);
        int n7 = this.getLineEndOffset(n5);
        while (++n <= n3) {
            string3 = this.getText(n - 1, 1);
            if (string3.matches("\"") && !this.isEscaped(n)) {
                boolean bl = true;
                int n8 = n;
                while (++n8 <= n7) {
                    bl = false;
                    String string4 = this.getText(n8 - 1, 1);
                    if (!string4.equals("\"") || this.isEscaped(n8)) continue;
                    n = n8;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return;
            }
            if (string3.matches("[(]|[\\[]|[{]") && !this.isEscaped(n)) {
                ++n4;
                continue;
            }
            if (!string3.matches("[)]|[\\]]|[}]") || this.isEscaped(n) || --n4 != 0) continue;
            if (string3.equals(string2)) {
                this.highlight(this, string, n2, this.ParanthesisHighlight);
                this.highlight(this, string2, n, this.ParanthesisHighlight);
            } else {
                this.highlight(this, string, n2, this.ParanthesisHighlightMissing);
                this.highlight(this, string2, n, this.ParanthesisHighlightMissing);
            }
            return;
        }
    }

    public void highlightParanthesisBackward(String string, int n) throws BadLocationException {
        int n2 = n;
        String string2 = null;
        if (string.equals("}")) {
            string2 = "{";
        }
        if (string.equals(")")) {
            string2 = "(";
        }
        if (string.equals("]")) {
            string2 = "[";
        }
        if (string2 == null) {
            return;
        }
        String string3 = null;
        int n3 = 1;
        int n4 = this.getLineOfOffset(n2);
        int n5 = this.getLineStartOffset(n4);
        int n6 = this.getLineEndOffset(n4);
        while (--n > 0) {
            string3 = this.getText(n - 1, 1);
            if (string3.matches("\"") && !this.isEscaped(n)) {
                boolean bl = true;
                int n7 = n;
                while (--n7 > n5) {
                    bl = false;
                    String string4 = this.getText(n7 - 1, 1);
                    if (!string4.equals("\"") || this.isEscaped(n7)) continue;
                    n = n7;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return;
            }
            if (string3.matches("[)]|[\\]]|[}]") && !this.isEscaped(n)) {
                ++n3;
                continue;
            }
            if (!string3.matches("[(]|[\\[]|[{]") || this.isEscaped(n) || --n3 != 0) continue;
            if (string3.equals(string2)) {
                this.highlight(this, string, n2, this.ParanthesisHighlight);
                this.highlight(this, string2, n, this.ParanthesisHighlight);
            } else {
                this.highlight(this, string, n2, this.ParanthesisHighlightMissing);
                this.highlight(this, string2, n, this.ParanthesisHighlightMissing);
            }
            return;
        }
    }

    public void highlight(JTextComponent jTextComponent, String string, int n, HighlightPainter highlightPainter) {
        try {
            Highlighter highlighter = jTextComponent.getHighlighter();
            if (n == 0) {
                ++n;
            }
            highlighter.addHighlight(n - 1, n, highlightPainter);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void removeHighlights() {
        Highlighter highlighter = this.getHighlighter();
        Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
        for (int i = 0; i < highlightArray.length; ++i) {
            if (!(highlightArray[i].getPainter() instanceof HighlightPainter)) continue;
            highlighter.removeHighlight(highlightArray[i]);
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        block11: {
            SyntaxArea syntaxArea = this;
            this.removeHighlights();
            try {
                String string;
                int n;
                if (caretEvent.getDot() == 0) {
                    return;
                }
                if (!this.getText(caretEvent.getDot() - 1, 1).matches("[(]|[\\[]|[{]|[)]|[\\]]|[}]")) break block11;
                this.removeCaretListener(syntaxArea);
                try {
                    n = caretEvent.getDot();
                    string = this.getText(n - 1, 1);
                    if (syntaxArea.isEscaped(n)) {
                        this.addCaretListener(syntaxArea);
                        return;
                    }
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                    this.addCaretListener(syntaxArea);
                    return;
                }
                try {
                    if (string.matches("[(]|[\\[]|[{]")) {
                        this.highlightParanthesisForward(string, n);
                    } else if (string.matches("[)]|[\\]]|[}]")) {
                        this.highlightParanthesisBackward(string, n);
                    }
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                }
                this.addCaretListener(syntaxArea);
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dropTargetDropEvent.acceptDrop(3);
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (Exception exception) {
            dropTargetDropEvent.rejectDrop();
        }
    }

    class HighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public HighlightPainter(Color color) {
            super(color);
        }
    }
}

