/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.CannotUndoException;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.editor.FindReplaceDialog;
import org.rosuda.JGR.toolkit.AboutDialog;
import org.rosuda.JGR.toolkit.FileSelector;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.PrefsDialog;
import org.rosuda.JGR.toolkit.SyntaxInput;
import org.rosuda.JGR.toolkit.TextFinder;
import org.rosuda.JGR.toolkit.ToolBar;
import org.rosuda.JGR.toolkit.iFrame;
import org.rosuda.JGR.toolkit.iMenu;
import org.rosuda.JGR.util.DocumentRenderer;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.ibase.Common;
import org.rosuda.util.RecentList;

public class Editor
extends iFrame
implements ActionListener,
KeyListener {
    private final CaretListenerLabel caretStatus = new CaretListenerLabel();
    private final JLabel modifiedStatus = new JLabel();
    private final SyntaxInput editArea = new SyntaxInput("editor", true);
    private final Document editDoc = this.editArea.getDocument();
    private ToolBar toolBar;
    String fileName = null;
    private boolean modified = false;
    private final TextFinder textFinder = new TextFinder(this.editArea);
    public static RecentList recentOpen;
    public JMenu recentMenu;

    public Editor() {
        this((String)null);
    }

    public Editor(String string) {
        super("Editor", 150);
        Object object;
        Object object2;
        String[] stringArray = new String[]{"+", "File", "@NNew", "new", "@OOpen", "open", "#Open Recent", "", "@SSave", "save", "!SSave as", "saveas", "-", "@PPrint", "print", "~File.Basic.End", "~Editor", "+", "Tools", "Increase Font Size", "fontBigger", "Decrease Font Size", "fontSmaller", "~Window", "~Help", "~About", "0"};
        iMenu.getMenu(this, this, stringArray);
        JMenu jMenu = this.recentMenu = (JMenu)iMenu.getItemByLabel(this, "Open Recent");
        if (jMenu != null) {
            JMenuItem jMenuItem;
            int n;
            if (recentOpen == null) {
                recentOpen = new RecentList("JGR", "RecentOpenFiles", 8);
            }
            object2 = recentOpen.getShortEntries();
            object = recentOpen.getAllEntries();
            for (n = 0; n < ((String[])object2).length; ++n) {
                jMenuItem = new JMenuItem(object2[n]);
                jMenuItem.setActionCommand("recent:" + object[n]);
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
            }
            if (n > 0) {
                jMenu.addSeparator();
            }
            jMenuItem = new JMenuItem("Clear list");
            jMenuItem.setActionCommand("recent-clear");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            if (n == 0) {
                jMenuItem.setEnabled(false);
            }
        }
        this.toolBar = new ToolBar(this, false);
        this.editArea.addCaretListener(this.caretStatus);
        this.editArea.addKeyListener(this);
        this.editArea.setWordWrap(false);
        this.editDoc.addUndoableEditListener(this.toolBar.undoMgr);
        this.caretStatus.setMinimumSize(new Dimension(100, 15));
        this.caretStatus.setPreferredSize(new Dimension(100, 15));
        this.caretStatus.setMaximumSize(new Dimension(100, 15));
        this.modifiedStatus.setMinimumSize(new Dimension(80, 15));
        this.modifiedStatus.setPreferredSize(new Dimension(80, 15));
        this.modifiedStatus.setMaximumSize(new Dimension(80, 15));
        object2 = new JPanel(new FlowLayout(2));
        ((Container)object2).add(this.modifiedStatus);
        ((Container)object2).add(this.caretStatus);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        object = new JScrollPane(this.editArea);
        ((JScrollPane)object).setVerticalScrollBarPolicy(22);
        this.getContentPane().add((Component)object, "Center");
        this.getContentPane().add((Component)object2, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Editor.this.exit();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                super.componentResized(componentEvent);
                Editor.this.setTitle(Editor.this.fileName);
            }
        });
        this.setMinimumSize(new Dimension(600, 600));
        this.setSize(new Dimension(600, Common.screenRes.height < 800 ? Common.screenRes.height - 50 : 700));
        this.setLocation(this.getLocation().x + 100, 10);
        this.setVisible(true);
        this.editArea.mComplete.setVisible(false);
        if (string != null) {
            this.fileName = string;
        }
        if (this.fileName != null) {
            this.loadFile();
        }
        this.setTitle(this.fileName == null ? "" : this.fileName);
        this.editArea.requestFocus();
    }

    public void setTitle(String string) {
        int n;
        int n2 = 1;
        if (System.getProperty("os.name").startsWith("Win")) {
            super.setTitle(string == null ? "Editor" : string);
            return;
        }
        try {
            n = this.getFontMetrics(this.getFont()).stringWidth(string);
        }
        catch (Exception exception) {
            super.setTitle(string == null ? "Editor" : string);
            return;
        }
        boolean bl = true;
        while (n > this.getWidth() - 100 && bl) {
            int n3;
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
            int n4 = stringTokenizer.countTokens();
            string = !JGRPrefs.isMac ? stringTokenizer.nextElement() + "" + File.separator : File.separator;
            if (n2 > n4) {
                for (n3 = 1; n3 < n4 && stringTokenizer.hasMoreTokens(); ++n3) {
                    stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                }
                bl = false;
            } else {
                for (n3 = 1; n3 <= n4 && stringTokenizer.hasMoreTokens(); ++n3) {
                    if (n3 <= n4 / 2 - (n2 - n2 / 2) || n3 > n4 / 2 + n2 / 2) {
                        string = string + stringTokenizer.nextToken() + "" + (stringTokenizer.hasMoreTokens() ? File.separator : "");
                        continue;
                    }
                    string = string + "..." + File.separator;
                    stringTokenizer.nextToken();
                }
                bl = true;
            }
            n = this.getFontMetrics(this.getFont()).stringWidth(string);
            ++n2;
        }
        super.setTitle(string);
    }

    public boolean exit() {
        if (this.modified) {
            int n = JOptionPane.showConfirmDialog(this, "Save File?", "Exit", 1, 3);
            if (n == 1) {
                this.dispose();
                return true;
            }
            if (n == 0 && this.saveFile()) {
                this.dispose();
                return true;
            }
            return false;
        }
        this.dispose();
        return true;
    }

    public void open() {
        FileSelector fileSelector = new FileSelector(this, "Open...", 0, JGRPrefs.workingDirectory);
        fileSelector.setVisible(true);
        if (Common.isMac()) {
            this.openFile(fileSelector);
        } else if (((JFileChooser)fileSelector.getSelector()).toString().indexOf("APPROVE_OPTION") != -1) {
            this.openFile(fileSelector);
        }
    }

    private void openFile(FileSelector fileSelector) {
        String string = null;
        if (fileSelector.getFile() != null) {
            JGRPrefs.workingDirectory = fileSelector.getDirectory();
            string = JGRPrefs.workingDirectory + fileSelector.getFile();
        }
        if (this.editArea.getText().length() == 0 && string != null && string.trim().length() > 0) {
            this.fileName = string;
            this.loadFile();
        } else if (string != null && string.trim().length() > 0) {
            new Editor(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile() {
        String[] stringArray;
        Object object;
        this.setWorking(true);
        this.editArea.setText("");
        try {
            object = new BufferedReader(new FileReader(this.fileName));
            try {
                stringArray = new StringBuffer();
                while (((BufferedReader)object).ready()) {
                    stringArray.append(((BufferedReader)object).readLine() + "\n");
                    if (stringArray.length() <= 32000) continue;
                    this.editArea.append(stringArray.toString());
                    stringArray.delete(0, stringArray.length());
                    try {
                        Thread.sleep(2L);
                    }
                    catch (Exception exception) {}
                }
                ((BufferedReader)object).close();
                this.editArea.append(stringArray.toString());
                stringArray.delete(0, stringArray.length());
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
                this.setWorking(false);
            }
            this.setWorking(false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Could not find selected File.", "File not found!", 0);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
        finally {
            this.editArea.setCaretPosition(0);
            this.setWorking(false);
        }
        recentOpen.addEntry(this.fileName);
        this.recentMenu = (JMenu)iMenu.getItemByLabel(this, "Open Recent");
        object = this.recentMenu;
        if (object != null) {
            JMenuItem jMenuItem;
            int n;
            ((JMenu)object).removeAll();
            if (recentOpen == null) {
                recentOpen = new RecentList("JGR", "RecentOpenFiles", 8);
            }
            stringArray = recentOpen.getShortEntries();
            String[] stringArray2 = recentOpen.getAllEntries();
            for (n = 0; n < stringArray.length; ++n) {
                jMenuItem = new JMenuItem(stringArray[n]);
                jMenuItem.setActionCommand("recent:" + stringArray2[n]);
                jMenuItem.addActionListener(this);
                ((JMenu)object).add(jMenuItem);
            }
            if (n > 0) {
                ((JMenu)object).addSeparator();
            }
            jMenuItem = new JMenuItem("Clear list");
            jMenuItem.setActionCommand("recent-clear");
            jMenuItem.addActionListener(this);
            ((JMenu)object).add(jMenuItem);
            if (n == 0) {
                jMenuItem.setEnabled(false);
            }
        }
        this.setTitle(this.fileName == null ? "Editor" : this.fileName);
        this.editArea.requestFocus();
    }

    public void setText(StringBuffer stringBuffer) {
        this.cursorWait();
        this.editArea.setText(stringBuffer.toString());
        this.cursorDefault();
    }

    public void print() {
        DocumentRenderer documentRenderer = new DocumentRenderer();
        documentRenderer.print(this.editArea);
    }

    public boolean saveFile() {
        if (this.fileName == null || this.fileName.equals("")) {
            return this.saveFileAs();
        }
        this.setWorking(true);
        new FileSave(this);
        this.setTitle(this.fileName == null ? "Editor" : this.fileName);
        this.modified = false;
        this.setModified(false);
        return true;
    }

    public boolean saveFileAs() {
        FileSelector fileSelector = new FileSelector(this, "Save as...", 1, JGRPrefs.workingDirectory);
        fileSelector.setVisible(true);
        if (fileSelector.getFile() != null) {
            JGRPrefs.workingDirectory = fileSelector.getDirectory();
            this.fileName = JGRPrefs.workingDirectory + fileSelector.getFile();
            return this.saveFile();
        }
        return false;
    }

    private void setModified(boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Editor.this.modifiedStatus.setText(Editor.this.modified ? "Modified" : "");
            }
        });
    }

    private void startNew() {
        new Editor();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "about") {
            new AboutDialog(this);
        } else if (string == "cut") {
            this.editArea.cut();
        } else if (string == "commentcode") {
            if (this.editArea.getSelectedText().trim().length() > 0) {
                try {
                    this.editArea.commentSelection(true);
                }
                catch (BadLocationException badLocationException) {}
            }
        } else if (string == "uncommentcode") {
            if (this.editArea.getSelectedText().trim().length() > 0) {
                try {
                    this.editArea.commentSelection(false);
                }
                catch (BadLocationException badLocationException) {}
            }
        } else if (string == "copy") {
            this.editArea.copy();
        } else if (string == "delete") {
            try {
                int n = 0;
                n = this.editArea.getSelectionStart();
                this.editDoc.remove(n, this.editArea.getSelectionEnd() - n);
            }
            catch (BadLocationException badLocationException) {}
        } else if (string == "exit") {
            this.exit();
        } else if (string == "fontBigger") {
            FontTracker.current.setFontBigger();
        } else if (string == "fontSmaller") {
            FontTracker.current.setFontSmaller();
        } else if (string == "fontBigger") {
            FontTracker.current.setFontBigger();
        } else if (string == "fontSmaller") {
            FontTracker.current.setFontSmaller();
        } else if (string == "help") {
            JGR.MAINRCONSOLE.execute("help.start()", false);
        } else if (string == "new") {
            this.startNew();
        } else if (string == "objectmgr") {
            JGR.MAINRCONSOLE.execute("object.manager()", false);
        } else if (string == "open") {
            this.open();
        } else if (string.startsWith("recent:")) {
            if (this.modified) {
                new Editor(string.replaceFirst("recent:", ""));
            } else {
                this.fileName = string.replaceFirst("recent:", "");
                this.loadFile();
            }
        } else if (string == "paste") {
            this.editArea.paste();
        } else if (string == "prefs") {
            new PrefsDialog(this);
        } else if (string == "print") {
            this.print();
        } else if (string == "recent-clear") {
            if (recentOpen != null && this.recentMenu != null) {
                this.recentMenu.removeAll();
                this.recentMenu.addSeparator();
                JMenuItem jMenuItem = new JMenuItem("Clear list");
                jMenuItem.setActionCommand("recent-clear");
                jMenuItem.addActionListener(this);
                jMenuItem.setEnabled(false);
                this.recentMenu.add(jMenuItem);
                recentOpen.reset();
            }
        } else if (string == "redo") {
            try {
                if (this.toolBar.undoMgr.canRedo()) {
                    this.toolBar.undoMgr.redo();
                }
            }
            catch (CannotUndoException cannotUndoException) {}
        } else if (string == "runall") {
            try {
                String string2 = this.editArea.getText();
                if (string2.length() > 0) {
                    JGR.MAINRCONSOLE.execute(string2.trim(), true);
                }
            }
            catch (Exception exception) {}
        } else if (string == "runselection") {
            try {
                String string3 = this.editArea.getSelectedText().trim();
                if (string3.length() > 0) {
                    JGR.MAINRCONSOLE.execute(string3.trim(), true);
                }
            }
            catch (Exception exception) {}
        } else if (string == "save") {
            this.saveFile();
        } else if (string == "saveas") {
            this.saveFileAs();
        } else if (string == "search") {
            FindReplaceDialog.findExt(this, this.editArea);
        } else if (string == "searchnext") {
            FindReplaceDialog.findNextExt(this, this.editArea);
        } else if (string == "selAll") {
            this.editArea.selectAll();
        } else if (string == "shiftleft") {
            try {
                this.editArea.shiftSelection(-1);
            }
            catch (BadLocationException badLocationException) {}
        } else if (string == "shiftright") {
            try {
                this.editArea.shiftSelection(1);
            }
            catch (BadLocationException badLocationException) {}
        } else if (string == "undo") {
            try {
                if (this.toolBar.undoMgr.canUndo()) {
                    this.toolBar.undoMgr.undo();
                }
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.modified = true;
        this.setModified(true);
        if (keyEvent.getKeyCode() == 10) {
            if ((keyEvent.isControlDown() || keyEvent.isMetaDown()) && JGR.MAINRCONSOLE != null && this.editArea.getSelectedText() != null) {
                JGR.MAINRCONSOLE.execute(this.editArea.getSelectedText(), true);
            } else if (this.editArea.mComplete != null && this.editArea.mComplete.isVisible()) {
                this.editArea.mComplete.completeCommand();
            } else if (!keyEvent.isControlDown() && !keyEvent.isMetaDown()) {
                try {
                    this.editArea.replaceSelection("");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.editArea.insertAt(this.editArea.getCaretPosition(), "\n");
            }
        } else if (keyEvent.getKeyCode() == 38) {
            if (this.editArea.mComplete != null && this.editArea.mComplete.isVisible()) {
                this.editArea.mComplete.selectPrevious();
            }
        } else if (keyEvent.getKeyCode() == 40 && this.editArea.mComplete != null && this.editArea.mComplete.isVisible()) {
            this.editArea.mComplete.selectNext();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    class FileSave
    extends Thread {
        private String fileName;
        private BufferedWriter writer;
        private Editor editor;

        public FileSave(Editor editor2) {
            this.fileName = editor2.fileName;
            this.editor = editor2;
            try {
                this.writer = new BufferedWriter(new FileWriter(this.fileName));
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.writer.write(Editor.this.editArea.getText());
                this.writer.flush();
                this.writer.close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.editor, "Permisson denied", "File Errror", 0);
            }
            finally {
                this.editor.setWorking(false);
            }
        }
    }

    protected class CaretListenerLabel
    extends JLabel
    implements CaretListener {
        public void caretUpdate(CaretEvent caretEvent) {
            this.displayInfo(caretEvent);
        }

        protected void displayInfo(CaretEvent caretEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        int n = Editor.this.editArea.getCaretPosition();
                        int n2 = Editor.this.editArea.getText().lastIndexOf("\n", n - 1);
                        int n3 = Editor.this.editArea.getText(0, n2 < 0 ? 0 : n2).length();
                        int n4 = Editor.this.editArea.getLineOfOffset(Editor.this.editArea.getCaretPosition());
                        CaretListenerLabel.this.setText(n4 + ":" + (n4 == 0 ? n + 1 : (n -= n3)));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
    }
}

