/*
 * Decompiled with CFR 0.152.
 */
package jedit.syntax;

import javax.swing.text.Segment;
import jedit.syntax.KeywordMap;
import jedit.syntax.TokenMarker;

public class SQLTokenMarker
extends TokenMarker {
    private int offset;
    private int lastOffset;
    private int lastKeyword;
    private int length;
    protected boolean isTSQL = false;
    private KeywordMap keywords;
    private char literalChar = '\u0000';

    public SQLTokenMarker(KeywordMap keywordMap) {
        this(keywordMap, false);
    }

    public SQLTokenMarker(KeywordMap keywordMap, boolean bl) {
        this.keywords = keywordMap;
        this.isTSQL = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte markTokensImpl(byte by, Segment segment, int n) {
        this.lastOffset = this.lastKeyword = segment.offset;
        this.offset = this.lastKeyword;
        this.length = segment.count + this.offset;
        block13: for (int i = this.offset; i < this.length; ++i) {
            switch (segment.array[i]) {
                case '*': {
                    if (by == 1 && this.length - i >= 1 && segment.array[i + 1] == '/') {
                        by = 0;
                        this.addToken(++i + 1 - this.lastOffset, (byte)1);
                        this.lastOffset = i + 1;
                        break;
                    }
                    if (by != 0) break;
                    this.searchBack(segment, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '[': {
                    if (by != 0) break;
                    this.searchBack(segment, i);
                    by = (byte)3;
                    this.literalChar = (char)91;
                    this.lastOffset = i;
                    break;
                }
                case ']': {
                    if (by != 3 || this.literalChar != '[') break;
                    by = 0;
                    this.literalChar = '\u0000';
                    this.addToken(i + 1 - this.lastOffset, (byte)3);
                    this.lastOffset = i + 1;
                    break;
                }
                case '(': 
                case ')': 
                case ',': 
                case '.': {
                    if (by != 0) break;
                    this.searchBack(segment, i);
                    this.addToken(1, (byte)0);
                    this.lastOffset = i + 1;
                    break;
                }
                case '%': 
                case '&': 
                case '+': 
                case '<': 
                case '=': 
                case '>': 
                case '^': 
                case '|': 
                case '~': {
                    if (by != 0) break;
                    this.searchBack(segment, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (by != 0) break;
                    this.searchBack(segment, i, false);
                    break;
                }
                case ':': {
                    if (by != 0) break;
                    this.addToken(i + 1 - this.lastOffset, (byte)5);
                    this.lastOffset = i + 1;
                    break;
                }
                case '/': {
                    if (by != 0) break;
                    if (this.length - i >= 2 && segment.array[i + 1] == '*') {
                        this.searchBack(segment, i);
                        by = 1;
                        this.lastOffset = i++;
                        break;
                    }
                    this.searchBack(segment, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '-': {
                    if (by != 0) break;
                    if (this.length - i >= 2 && segment.array[i + 1] == '-') {
                        this.searchBack(segment, i);
                        this.addToken(this.length - i, (byte)1);
                        this.lastOffset = this.length;
                        break block13;
                    }
                    this.searchBack(segment, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '!': {
                    if (!this.isTSQL || by != 0 || this.length - i < 2 || segment.array[i + 1] != '=' && segment.array[i + 1] != '<' && segment.array[i + 1] != '>') break;
                    this.searchBack(segment, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '\"': 
                case '\'': {
                    if (by == 0) {
                        by = (byte)3;
                        this.literalChar = segment.array[i];
                        this.addToken(i - this.lastOffset, (byte)0);
                        this.lastOffset = i;
                        break;
                    }
                    if (by != 3 || this.literalChar != segment.array[i]) break;
                    by = 0;
                    this.literalChar = '\u0000';
                    this.addToken(i + 1 - this.lastOffset, (byte)3);
                    this.lastOffset = i + 1;
                }
            }
        }
        if (by == 0) {
            this.searchBack(segment, this.length, false);
        }
        if (this.lastOffset != this.length) {
            this.addToken(this.length - this.lastOffset, by);
        }
        return by;
    }

    private void searchBack(Segment segment, int n) {
        this.searchBack(segment, n, true);
    }

    private void searchBack(Segment segment, int n, boolean bl) {
        int n2 = n - this.lastKeyword;
        byte by = this.keywords.lookup(segment, this.lastKeyword, n2);
        if (by != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n2, by);
            this.lastOffset = n;
        }
        this.lastKeyword = n + 1;
        if (bl && this.lastOffset < n) {
            this.addToken(n - this.lastOffset, (byte)0);
        }
    }
}

