/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.undo.CannotUndoException;
import org.rosuda.JGR.DataLoader;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.browser.BrowserWindow;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.editor.FindReplaceDialog;
import org.rosuda.JGR.toolkit.AboutDialog;
import org.rosuda.JGR.toolkit.ConsoleOutput;
import org.rosuda.JGR.toolkit.DataTable;
import org.rosuda.JGR.toolkit.FileSelector;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.PrefDialog;
import org.rosuda.JGR.toolkit.SelectionPreservingCaret;
import org.rosuda.JGR.toolkit.SyntaxInput;
import org.rosuda.JGR.toolkit.ToolBar;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.JRI.JRIEngine;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REngineException;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;
import org.rosuda.ibase.toolkit.WTentry;
import org.rosuda.ibase.toolkit.WinTracker;

public class JGRConsole
extends TJFrame
implements ActionListener,
KeyListener,
FocusListener,
RMainLoopCallbacks {
    public static final int MENUMODIFIER = Common.isMac() ? 4 : 2;
    private static final long serialVersionUID = 7379785188574795119L;
    public static String guiEnv = "gui.working.env";
    public static String lastRPrompt = "> ";
    private final JSplitPane consolePanel = new JSplitPane(0);
    private final StringBuffer console = new StringBuffer();
    public ConsoleOutput output = new ConsoleOutput();
    public SyntaxInput input = new SyntaxInput("console", true);
    public Document inputDoc = this.input.getDocument();
    public Document outputDoc = this.output.getDocument();
    public int currentHistPosition = 0;
    public int end = 0;
    private ToolBar toolBar;
    private String wspace = null;
    private boolean wasHistEvent = false;
    private Integer clearpoint = null;
    private int readCount = 0;

    public JGRConsole() {
        this((File)null);
    }

    public JGRConsole(File workSpace) {
        super("Console", false, 1);
        String[] Menu = new String[]{"+", "File", "New Data", "newdata", "@LLoad Data", "loaddata", "-", "@NNew Document", "new", "@OOpen Document", "open", "!OSource File...", "source", "@SSave", "save", "-", "@DSet Working Directory", "setwd", "~File.Quit", "+", "Edit", "@ZUndo", "undo", "!ZRedo", "redo", "-", "@XCut", "cut", "@CCopy", "copy", "#Copy Special", "-", "@VPaste", "paste", "Delete", "delete", "@ASelect All", "selAll", "-", "@FFind", "search", "@GFind Next", "searchnext", "-", "!LClear Console", "clearconsole", "-", "!IIncrease Font Size", "fontBigger", "!DDecrease Font Size", "fontSmaller", "+", "Workspace", "Open", "openwsp", "Save", "savewsp", "Save as...", "saveaswsp", "-", "Clear All", "clearwp", "+", "Packages & Data", "@BObject Browser", "objectmgr", "Data Table", "table", "-", "Package Manager", "packagemgr", "Package Installer", "packageinst", "~Window", "+", "Help", "R Help", "help", "~Preferences", "~About", "0"};
        JMenuBar mb = EzMenuSwing.getEzMenu(this, this, Menu);
        JMenu rm = (JMenu)EzMenuSwing.getItem(this, "Copy Special");
        if (rm != null) {
            JMenuItem item1 = new JMenuItem("Copy Output");
            item1.setActionCommand("copyoutput");
            item1.addActionListener(this);
            rm.add(item1);
            JMenuItem item2 = new JMenuItem("Copy Commands");
            item2.setActionCommand("copycmds");
            item2.addActionListener(this);
            rm.add(item2);
            JMenuItem item3 = new JMenuItem("Copy Result");
            item3.setActionCommand("copyresult");
            item3.addActionListener(this);
            rm.add(item3);
        }
        if (!Common.isMac()) {
            EzMenuSwing.addMenuSeparator(this, "Edit");
            EzMenuSwing.addJMenuItem(this, "Edit", "Preferences", "preferences", this);
            EzMenuSwing.addJMenuItem(this, "Help", "About", "about", this);
            for (int i = 0; i < mb.getMenuCount(); ++i) {
                if (mb.getMenu(i).getText().equals("Preferences") || mb.getMenu(i).getText().equals("About")) {
                    mb.remove(i);
                    --i;
                }
                if (!mb.getMenu(i).getText().equals("Edit")) continue;
                JMenuItem prefer = (JMenuItem)mb.getMenu(i).getMenuComponent(mb.getMenu(i).getMenuComponentCount() - 1);
                prefer.setAccelerator(KeyStroke.getKeyStroke(44, MENUMODIFIER));
            }
        }
        try {
            URL url = this.getClass().getResource("/icons/JGR.png");
            if (url != null) {
                Toolkit kit = Toolkit.getDefaultToolkit();
                Image img = kit.createImage(url);
                this.getFrame().setIconImage(img);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (JGR.RHISTORY == null) {
            JGR.RHISTORY = new Vector();
        }
        this.currentHistPosition = JGR.RHISTORY.size();
        this.toolBar = new ToolBar(this, true);
        this.input.addKeyListener(this);
        this.input.setWordWrap(false);
        this.input.addFocusListener(this);
        this.inputDoc.addUndoableEditListener(this.toolBar.undoMgr);
        this.input.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.output.setEditable(false);
        this.output.addFocusListener(this);
        this.output.addKeyListener(this);
        this.output.setDragEnabled(true);
        this.output.setCaret(new SelectionPreservingCaret());
        this.output.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JScrollPane sp1 = new JScrollPane(this.output);
        sp1.setVerticalScrollBarPolicy(22);
        this.consolePanel.setTopComponent(sp1);
        JScrollPane sp2 = new JScrollPane(this.input);
        sp2.setVerticalScrollBarPolicy(22);
        this.consolePanel.setBottomComponent(sp2);
        this.consolePanel.setDividerLocation((int)((double)this.getHeight() * 0.65));
        this.consolePanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.consolePanel.setDividerSize(5);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                int w;
                super.componentResized(evt);
                if (JGR.getREngine() != null && JGR.STARTED && (w = JGRConsole.this.getFontWidth()) > 0) {
                    JGR.threadedEval("options(width=" + w + ")");
                }
                JGRConsole.this.consolePanel.setDividerLocation((int)((double)JGRConsole.this.getHeight() * 0.7));
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JGRConsole.this.dispose();
            }
        });
        this.addKeyListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.consolePanel, "Center");
        this.setMinimumSize(new Dimension(555, 650));
        this.setSize(new Dimension(JGRPrefs.consoleWidth, Common.screenRes.height < JGRPrefs.consoleHeight ? Common.screenRes.height - 50 : JGRPrefs.consoleHeight));
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.input.mComplete.setVisible(false);
        new Thread(new Refresher()).start();
    }

    public void exit() {
        Enumeration e = WinTracker.current.elements();
        while (e.hasMoreElements()) {
            WTentry we = (WTentry)e.nextElement();
            if (we.wclass != 150 || ((Editor)we.w).exit()) continue;
            return;
        }
        this.execute("q()", false);
    }

    public void dispose() {
        Enumeration e = WinTracker.current.elements();
        while (e.hasMoreElements()) {
            WTentry we = (WTentry)e.nextElement();
            if (we.wclass != 150 || ((Editor)we.w).exit()) continue;
            return;
        }
        this.execute("q()", false);
    }

    public void execute(String cmd) {
        this.execute(cmd, true);
    }

    public void execute(String cmd, boolean addToHist) {
        if (!JGR.STARTED) {
            return;
        }
        if (addToHist && JGR.RHISTORY.size() == 0) {
            JGR.RHISTORY.add(cmd);
        } else if (addToHist && cmd.trim().length() > 0 && JGR.RHISTORY.size() > 0 && !JGR.RHISTORY.lastElement().equals(cmd.trim())) {
            JGR.RHISTORY.add(cmd);
        }
        this.currentHistPosition = JGR.RHISTORY.size();
        final String[] cmdArray = cmd.split("\n");
        new Thread(new Runnable(){

            public void run() {
                String c = null;
                for (int i = 0; i < cmdArray.length; ++i) {
                    c = cmdArray[i];
                    if (!JGRConsole.this.isSupported(c)) continue;
                    String c1 = c;
                    JGR.rSync.triggerNotification(c1.trim());
                }
            }
        }).start();
    }

    public String getUniqueName(String var) {
        JGR.refreshObjects();
        var = RController.makeValidVariableName(var);
        if (!JGR.OBJECTS.contains(var)) {
            return var;
        }
        int i = 1;
        while (JGR.OBJECTS.contains(var + i)) {
            ++i;
        }
        return var + i;
    }

    public String getUniqueName(String var, String envName) {
        var = RController.makeValidVariableName(var);
        try {
            REXPLogical temp = (REXPLogical)JGR.eval("is.environment(" + envName + ")");
            boolean isEnv = temp.isTRUE()[0];
            if (!isEnv) {
                return var;
            }
        }
        catch (REngineException e) {
            new ErrorMsg(e);
            return var;
        }
        catch (REXPMismatchException e) {
            new ErrorMsg(e);
            return var;
        }
        boolean isUnique = false;
        try {
            REXPLogical temp = (REXPLogical)JGR.eval("exists('" + var + "',where=" + envName + ",inherits=FALSE)");
            isUnique = temp.isFALSE()[0];
            if (isUnique) {
                return var;
            }
        }
        catch (REngineException e) {
            new ErrorMsg(e);
            return var;
        }
        catch (REXPMismatchException e) {
            new ErrorMsg(e);
            return var;
        }
        int i = 1;
        while (true) {
            try {
                REXPLogical temp = (REXPLogical)JGR.eval("exists('" + var + i + "',where=" + envName + ",inherits=FALSE)");
                isUnique = temp.isFALSE()[0];
            }
            catch (REngineException e) {
                new ErrorMsg(e);
            }
            catch (REXPMismatchException e) {
                new ErrorMsg(e);
            }
            if (isUnique) {
                return var + i;
            }
            ++i;
        }
    }

    private boolean isSupported(String cmd) {
        if ((cmd = cmd.trim()).startsWith("fix(") || cmd.startsWith("edit(") || cmd.startsWith("edit.data.frame(")) {
            try {
                this.output.append(cmd + "\n", JGRPrefs.CMD);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.output.append("Editing is not supported yet!", JGRPrefs.RESULT);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.output.append("\n" + RController.getRPrompt(), JGRPrefs.CMD);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public void clearconsole() {
        try {
            if (this.end > 0 && this.clearpoint == null) {
                this.clearpoint = new Integer(this.output.getLineEndOffset(this.output.getLineOfOffset(this.end) - 1) + 2);
            }
            if (this.clearpoint != null) {
                this.output.removeAllFrom(this.clearpoint);
            }
        }
        catch (Exception e) {
            new ErrorMsg(e);
        }
    }

    public void loadWorkSpace() {
        FileSelector fopen = new FileSelector(this, "Open Workspace", 0);
        fopen.setVisible(true);
        if (fopen.getFile() != null) {
            JGRPrefs.workingDirectory = fopen.getDirectory();
            this.wspace = JGRPrefs.workingDirectory + fopen.getFile();
            this.execute("load(\"" + this.wspace.replace('\\', '/') + "\")");
        }
    }

    public void saveWorkSpace(String file) {
        if (file == null) {
            this.execute("save.image()");
        } else {
            this.execute("save.image(\"" + (file == null ? "" : file.replace('\\', '/')) + "\",compress=TRUE)");
        }
        JGR.writeHistory();
    }

    public void saveWorkSpaceAs() {
        FileSelector fsave = new FileSelector(this, "Save Workspace as...", 1);
        fsave.setVisible(true);
        if (fsave.getFile() != null) {
            JGRPrefs.workingDirectory = fsave.getDirectory();
            String file = JGRPrefs.workingDirectory + fsave.getFile();
            this.saveWorkSpace(file);
            JGR.writeHistory();
        }
    }

    public int getFontWidth() {
        int width = this.output.getFontMetrics(this.output.getFont()).charWidth('M');
        width = this.output.getWidth() / width;
        return width - (JGRPrefs.isMac ? 0 : 1);
    }

    public void rWriteConsole(Rengine re, String text, int oType) {
        if (this.readCount == 2) {
            this.end = this.output.getText().length();
            this.readCount = 3;
        }
        final String t = text;
        Runnable doWork = new Runnable(){

            public void run() {
                JGRConsole.this.console.append(t);
            }
        };
        SwingUtilities.invokeLater(doWork);
    }

    public void rWriteConsole(Rengine re, String text) {
        this.rWriteConsole(re, text, 0);
    }

    public void rBusy(Rengine re, int which) {
        final int fWhich = which;
        Runnable doWork = new Runnable(){

            public void run() {
                if (fWhich == 0) {
                    JGRConsole.this.setWorking(false);
                } else {
                    ((JGRConsole)JGRConsole.this).toolBar.stopButton.setEnabled(true);
                    JGRConsole.this.setWorking(true);
                }
            }
        };
        SwingUtilities.invokeLater(doWork);
    }

    public String rReadConsole(Rengine re, String prompt, int addToHistory) {
        if (this.readCount < 2) {
            ++this.readCount;
        }
        Runnable doWork = new Runnable(){

            public void run() {
                ((JGRConsole)JGRConsole.this).toolBar.stopButton.setEnabled(false);
            }
        };
        SwingUtilities.invokeLater(doWork);
        if (prompt.indexOf("Save workspace") > -1) {
            String retVal = JGR.exit();
            if (this.wspace != null && retVal.indexOf(121) >= 0) {
                try {
                    JGR.getREngine().eval(new REXPString("save.image(\"" + this.wspace.replace('\\', '/') + "\")"), null, false);
                }
                catch (REngineException e) {
                    new ErrorMsg(e);
                }
                catch (REXPMismatchException e) {
                    new ErrorMsg(e);
                }
                return "n\n";
            }
            return retVal;
        }
        lastRPrompt = prompt;
        final String fPrompt = prompt;
        Runnable doWork1 = new Runnable(){

            public void run() {
                String line;
                if (JGRConsole.this.console.length() > 0) {
                    JGRConsole.this.output.append(JGRConsole.this.console.toString(), JGRPrefs.RESULT);
                    JGRConsole.this.console.delete(0, JGRConsole.this.console.length());
                    JGRConsole.this.output.setCaretPosition(JGRConsole.this.outputDoc.getLength());
                }
                if ((line = JGRConsole.this.output.getLine(JGRConsole.this.output.getLineCount() - 1)) != null && line.length() > 0) {
                    JGRConsole.this.output.append("\n", JGRPrefs.RESULT);
                }
                JGRConsole.this.output.append(fPrompt, JGRPrefs.CMD);
                JGRConsole.this.output.setCaretPosition(JGRConsole.this.outputDoc.getLength());
            }
        };
        try {
            SwingUtilities.invokeAndWait(doWork1);
        }
        catch (Exception e1) {
            // empty catch block
        }
        final String s = JGR.rSync.waitForNotification();
        Runnable doWork2 = new Runnable(){

            public void run() {
                try {
                    JGRConsole.this.output.append(s + "\n", JGRPrefs.CMD);
                    if (JGRConsole.this.console.length() > 0) {
                        JGRConsole.this.output.append(JGRConsole.this.console.toString(), JGRPrefs.RESULT);
                        JGRConsole.this.console.delete(0, JGRConsole.this.console.length());
                        JGRConsole.this.output.setCaretPosition(JGRConsole.this.outputDoc.getLength());
                    }
                }
                catch (Exception e) {
                    new ErrorMsg(e);
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(doWork2);
        }
        catch (Exception e) {
            // empty catch block
        }
        return s == null || s.length() == 0 ? "\n" : s + "\n";
    }

    public void rShowMessage(Rengine re, String message) {
        JOptionPane.showMessageDialog(this, message, "R Message", 1);
    }

    public String rChooseFile(Rengine re, int newFile) {
        FileSelector fd = new FileSelector(this, newFile == 0 ? "Select a file" : "Select a new file", newFile == 0 ? 0 : 1);
        fd.setVisible(true);
        String res = null;
        if (fd.getDirectory() != null && fd.getFile() != null) {
            res = fd.getDirectory();
        }
        if (fd.getFile() != null) {
            res = res == null ? fd.getFile() : res + fd.getFile();
        }
        return res;
    }

    public void rFlushConsole(Rengine re) {
    }

    public void rLoadHistory(Rengine re, String filename) {
        File hist = null;
        try {
            hist = new File(filename);
            if (hist.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(hist));
                if (JGR.RHISTORY == null) {
                    JGR.RHISTORY = new Vector();
                }
                while (reader.ready()) {
                    JGR.RHISTORY.add(reader.readLine() + "\n");
                }
                reader.close();
            }
        }
        catch (Exception e) {
            new ErrorMsg(e);
        }
    }

    public void rSaveHistory(Rengine re, String filename) {
        try {
            File hist = new File(filename);
            BufferedWriter writer = new BufferedWriter(new FileWriter(hist));
            Enumeration e = JGR.RHISTORY.elements();
            while (e.hasMoreElements()) {
                writer.write(e.nextElement().toString() + "#\n");
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            new ErrorMsg(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "about") {
            new AboutDialog(this);
        } else if (cmd == "cut") {
            this.input.cut();
        } else if (cmd == "clearwsp") {
            this.execute("rm(list=ls())", false);
        } else if (cmd == "copy") {
            this.input.copy();
            this.output.copy();
        } else if (cmd == "copyoutput") {
            this.output.copyOutput();
        } else if (cmd != "print") {
            if (cmd == "copycmds") {
                this.output.copyCommands();
            } else if (cmd == "copyresult") {
                this.output.copyResults();
            } else if (cmd == "clearconsole") {
                this.clearconsole();
            } else if (cmd == "delete") {
                try {
                    int i = 0;
                    i = this.input.getSelectionStart();
                    this.inputDoc.remove(i, this.input.getSelectionEnd() - i);
                }
                catch (BadLocationException ex) {}
            } else if (cmd == "editor") {
                new Editor();
            } else if (cmd == "exit") {
                this.dispose();
            } else if (cmd == "exportOutput") {
                this.output.startExport();
            } else if (cmd == "fontBigger") {
                FontTracker.current.setFontBigger();
            } else if (cmd == "fontSmaller") {
                FontTracker.current.setFontSmaller();
            } else if (cmd == "newdata") {
                String inputValue = JOptionPane.showInputDialog("Data Name: ");
                if (inputValue != null) {
                    this.execute(inputValue.trim() + "<-data.frame()");
                }
            } else if (cmd == "loaddata") {
                new DataLoader();
            } else if (cmd == "open") {
                Editor temp = new Editor(null, false);
                temp.open();
            } else if (cmd == "openwsp") {
                this.loadWorkSpace();
            } else if (cmd == "new") {
                new Editor();
            } else if (cmd == "objectmgr") {
                Point cloc = this.getLocationOnScreen();
                int width = this.getWidth();
                BrowserWindow win = new BrowserWindow();
                win.setLocation(Math.min(cloc.x + width, Common.screenRes.width - 200), Math.min(Common.screenRes.height - 200, cloc.y));
                win.setVisible(true);
            } else if (cmd == "packagemgr") {
                this.execute("JGR::package.manager()", false);
            } else if (cmd == "packageinst") {
                this.execute("installPackages()", false);
            } else if (cmd == "paste") {
                this.input.paste();
            } else if (cmd == "preferences") {
                PrefDialog inst = PrefDialog.showPreferences(this);
                inst.setLocationRelativeTo(null);
                inst.setVisible(true);
            } else if (cmd == "redo") {
                try {
                    if (this.toolBar.undoMgr.canRedo()) {
                        this.toolBar.undoMgr.redo();
                    }
                }
                catch (CannotUndoException ex) {}
            } else if (cmd == "help") {
                this.execute("help.start()");
            } else if (cmd == "table") {
                new DataTable(null, null, true);
            } else if (cmd == "save") {
                this.output.startExport();
            } else if (cmd == "savewsp") {
                this.saveWorkSpace(this.wspace);
            } else if (cmd == "saveaswsp") {
                this.saveWorkSpaceAs();
            } else if (cmd == "clearwp") {
                int doIt = JOptionPane.showConfirmDialog(this, "Are you sure you wish to clear your workspace?\nAll unsaved objects will be deleted.", "Clear Workspace", 0);
                if (doIt == 0) {
                    this.execute("rm(list=setdiff(ls(), \"pkg\"))");
                }
            } else if (cmd == "search") {
                FindReplaceDialog.findExt(this, this.output);
            } else if (cmd == "searchnext") {
                FindReplaceDialog.findNextExt(this, this.output);
            } else if (cmd == "source") {
                this.execute("source(file.choose())", false);
            } else if (cmd == "stop") {
                try {
                    new Thread(new Runnable(){

                        public void run() {
                            ((JRIEngine)JGR.getREngine()).getRni().rniStop(0);
                        }
                    }).start();
                }
                catch (Exception exe) {
                    new ErrorMsg(exe);
                }
            } else if (cmd == "selAll") {
                if (this.input.isFocusOwner()) {
                    this.input.selectAll();
                } else if (this.output.isFocusOwner()) {
                    this.output.selectAll();
                }
            } else if (cmd == "undo") {
                try {
                    if (this.toolBar.undoMgr.canUndo()) {
                        this.toolBar.undoMgr.undo();
                    }
                }
                catch (Exception ex) {}
            } else if (cmd == "setwd") {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                chooser.setDialogTitle("Choose Working Directory");
                chooser.setApproveButtonText("Choose");
                int r = chooser.showOpenDialog(this);
                if (r == 1) {
                    return;
                }
                if (chooser.getSelectedFile() != null) {
                    JGRPrefs.workingDirectory = chooser.getSelectedFile().toString();
                }
                this.execute("setwd(\"" + chooser.getSelectedFile().toString().replace('\\', '/') + "\")");
            } else if (cmd == "update") {
                this.execute("update.JGR(contriburl=\"http://rosuda.org/R/nightly\")", false);
            }
        }
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void keyPressed(KeyEvent ke) {
        if (ke.getSource().equals(this.output) && !ke.isMetaDown() && !ke.isControlDown() && !ke.isAltDown()) {
            this.input.requestFocus();
        }
        if (ke.getKeyCode() == 38) {
            if (this.input.mComplete != null && this.input.mComplete.isVisible()) {
                this.input.mComplete.selectPrevious();
            } else if (this.currentHistPosition > 0 && (this.input.getCaretPosition() == 0 || this.input.getCaretPosition() == this.input.getText().length())) {
                this.input.setText(JGR.RHISTORY.get(--this.currentHistPosition).toString());
                this.input.setCaretPosition(this.input.getText().length());
                this.wasHistEvent = true;
            }
        } else if (ke.getKeyCode() == 40) {
            if (this.input.mComplete != null && this.input.mComplete.isVisible()) {
                this.input.mComplete.selectNext();
            } else if (this.input.getCaretPosition() == 0 || this.input.getCaretPosition() == this.input.getText().length()) {
                if (this.currentHistPosition < JGR.RHISTORY.size() - 1) {
                    this.input.setText(JGR.RHISTORY.get(++this.currentHistPosition).toString());
                    this.input.setCaretPosition(this.input.getText().length());
                } else if (JGR.RHISTORY.size() > 0 && this.currentHistPosition < JGR.RHISTORY.size()) {
                    this.input.setText("");
                    ++this.currentHistPosition;
                }
                this.wasHistEvent = true;
            }
        }
    }

    public void keyReleased(KeyEvent ke) {
        if (ke.getKeyCode() == 10) {
            if (this.input.mComplete != null && this.input.mComplete.isVisible() && !ke.isControlDown() && !ke.isMetaDown()) {
                this.input.mComplete.completeCommand();
            } else if (ke.isControlDown() || ke.isMetaDown()) {
                try {
                    this.inputDoc.insertString(this.input.getCaretPosition(), "\n", null);
                    this.input.mComplete.setVisible(false);
                }
                catch (Exception e) {}
            } else {
                String cmd = this.input.getText().trim();
                this.input.setText("");
                this.input.setCaretPosition(0);
                this.input.requestFocus();
                this.execute(cmd);
            }
        }
        if (ke.getSource().equals(this.output) && ke.getKeyCode() == 86 && (ke.isControlDown() || ke.isMetaDown())) {
            this.input.requestFocus();
            this.input.paste();
            this.input.setCaretPosition(this.input.getText().length());
        } else if ((ke.getKeyCode() == 38 || ke.getKeyCode() == 40) && this.wasHistEvent) {
            this.wasHistEvent = false;
            this.input.setCaretPosition(this.input.getText().length());
        }
    }

    public void focusGained(FocusEvent e) {
        if (e.getSource().equals(this.output)) {
            this.toolBar.cutButton.setEnabled(false);
            EzMenuSwing.getItem(this, "cut").setEnabled(false);
            this.toolBar.pasteButton.setEnabled(false);
            EzMenuSwing.getItem(this, "paste").setEnabled(false);
        } else if (e.getSource().equals(this.input)) {
            this.toolBar.cutButton.setEnabled(true);
            EzMenuSwing.getItem(this, "cut").setEnabled(true);
            this.toolBar.pasteButton.setEnabled(true);
            EzMenuSwing.getItem(this, "paste").setEnabled(true);
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public PrintStream getStdOutPrintStream() {
        MutableAttributeSet coloring = JGRPrefs.RESULT;
        return this.getPrintStream(coloring);
    }

    private PrintStream getPrintStream(final MutableAttributeSet coloring) {
        OutputStream out = new OutputStream(){

            public void write(int b) throws IOException {
                JGRConsole.this.output.append(String.valueOf((char)b), coloring);
            }
        };
        PrintStream p = new PrintStream(out);
        return p;
    }

    public PrintStream getStdErrPrintStream() {
        MutableAttributeSet coloring = JGRPrefs.RESULT;
        return this.getPrintStream(coloring);
    }

    class Refresher
    implements Runnable {
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                        Runnable doWorkRunnable = new Runnable(){

                            public void run() {
                                if (JGRConsole.this.console.length() > 0) {
                                    String line = ((Refresher)Refresher.this).JGRConsole.this.output.getLine(((Refresher)Refresher.this).JGRConsole.this.output.getLineCount() - 1);
                                    if (line != null && line.equals(lastRPrompt)) {
                                        ((Refresher)Refresher.this).JGRConsole.this.output.append("\n", JGRPrefs.CMD);
                                    }
                                    ((Refresher)Refresher.this).JGRConsole.this.output.append(JGRConsole.this.console.toString(), JGRPrefs.RESULT);
                                    JGRConsole.this.console.delete(0, JGRConsole.this.console.length());
                                    ((Refresher)Refresher.this).JGRConsole.this.output.setCaretPosition(((Refresher)Refresher.this).JGRConsole.this.outputDoc.getLength());
                                }
                            }
                        };
                        SwingUtilities.invokeLater(doWorkRunnable);
                    }
                }
                catch (Exception e) {
                    new ErrorMsg(e);
                    continue;
                }
                break;
            }
        }
    }
}

