% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdt_moderated.R
\name{mdt_moderated}
\alias{mdt_moderated}
\title{Fits a moderated mediation model}
\usage{
mdt_moderated(data, IV, DV, M, Mod)
}
\arguments{
\item{data}{A data frame containing the variables in the model.}

\item{IV}{An unquoted variable in the data frame which will be used as
the independent variable.}

\item{DV}{An unquoted variable in the data frame which will be used as
the dependent variable.}

\item{M}{An unquoted variable in the data frame which will be used as
the mediator.}

\item{Mod}{An unquoted variable in the data frame which will be used as
the moderator.}
}
\value{
Returns an object of class "\code{mediation_model}".

An object of class "\code{mediation_model}" is a list containing at least
the components:

\item{type}{A character string containing the type of model that has been
conducted (e.g., \code{"simple mediation"}).}
\item{method}{A character string containing the approach that has been
used to conduct the mediation analysis (usually
\code{"joint significance"}).} \item{params}{A named list of character
strings describing the variables used in the model.}
\item{paths}{A named list containing information on each relevant path of
the mediation model.}
\item{indirect_index}{A boolean indicating whether an indirect effect index
has been computed or not. Defaults to \code{FALSE}. See
\code{\link{add_index}} to compute mediation index.}
\item{indirect_index_infos}{(Optional) An object of class
\code{"indirect_index"}. Appears when one applies \code{\link{add_index}}
to an object of class \code{"mediation_model"}.}
\item{js_models}{A list of objects of class \code{"lm"}. Contains every
model relevant to joint-significance testing.}
\item{data}{The original data frame that has been passed through
\code{data} argument.}
}
\description{
Given a data frame, a predictor (\code{IV}), an outcome
(\code{DV}), a mediator (\code{M}), and a moderator (\code{Mod}) conducts a
joint-significant test for moderated mediation (see Yzerbyt, Muller,
Batailler, & Judd, 2018).
}
\details{
With moderated mediation analysis, one tests whether the
indirect effect of \eqn{X} on \eqn{Y} through \eqn{M} is moderated by
\eqn{Mod}. The hypothesis behind this test is that \eqn{X} has an effect on
\eqn{M} (\eqn{a}) which has an effect on \eqn{Y} (\eqn{b}), meaning that
\eqn{X} has an indirect effect on \eqn{Y} through \eqn{M}.

Total moderation of the indirect effect of \eqn{X} on \eqn{Y} can be
described as follows:

\eqn{c * Mod = c' * Mod + (a * Mod) * b + a * (b * Mod)}

with \eqn{c * Mod} the total moderation of the indirect effect, \eqn{c' *
  Mod} the moderation of the direct effect, \eqn{(a * Mod) * b}, the
moderation of the indirect effect passing by the moderation of \eqn{a}, and
\eqn{a * (b * Mod)}, the moderation of the indirect effect passing by the
moderation of \eqn{b} (see Models section; Muller et al., 2005).

Either both \eqn{a * Mod} and \eqn{b} or both \eqn{a} and \eqn{b * Mod}
need to be simultaneously significant for a moderation of the indirect
effect to be claimed (Muller et al., 2005).
}
\section{Models}{
 In a moderated mediation model, three models will be used:
\itemize{
\item \eqn{Y_i = b_{40} + \mathbf{b_{41}} X_i + b_{42} Mo_i + \mathbf{b_{43}}
  XMo_i }{Yi = b_41 + b41*Xi + b42*Moi + + b43*XMoi}
\item \eqn{M_i = b_{50} + \mathbf{b_{51}} X_i + b_{52} Mo_i + \mathbf{b_{53}
  XMo_i}}{Mi = b_50 + b_51*Xi + b_52 Moi + b53 XMoi}
\item \eqn{Y_i = b_{60} + \mathbf{c'_{61}} X_i + b_{62} Mo_i + \mathbf{b_{63}
  Xmo_i} + \mathbf{b_{64} Me_i} + \mathbf{b_{65} MeMo_i}}{Yi = b_60 + b61*Xi
  + b_62*Moi + b63 XMoi + b64 Mei + b65 MeMoi}
}

with \eqn{Y_i}{Yi}, the outcome value for the \emph{i}th observation,
\eqn{X_i}{Xi}, the predictor value for the \emph{i}th observation,
\eqn{Mo_i}{Xi}, the moderator value for the \emph{i}th observation, and
\eqn{M_i}{Mi}, the mediator value for the \emph{i}th observation.

Coefficients associated with \eqn{a}, \eqn{a \times Mod}{a * Mod}, \eqn{b},
\eqn{b \times Mod}{b * Mod}, \eqn{c}, \eqn{c \times Mod}{c * Mod},
\eqn{c'}, and \eqn{c' \times Mod}{c' * Mod}, paths are respectively
\eqn{b_{51}}{b_51}, \eqn{b_{53}}{b_53}, \eqn{b_{64}}{b_64},
\eqn{b_{65}}{b_65}, \eqn{b_{41}}{b_41}, \eqn{b_{43}}{b_43},
\eqn{b_{61}}{b_61}, and \eqn{b_{63}}{c63} (see Muller et al., 2005).
}

\section{Variable coding}{
 Because joint-significance tests use linear models
behind the scenes, variables involved in the model have to be numeric.
\code{mdt_simple} will give an error if non-numeric variables are
specified in the model.

If you need to convert a dichotomous categorical variable to a numeric one,
please refer to the \code{\link{build_contrast}} function.

Note that variable coding is especially important in models with multiple
predictors as is the case in the model used to conduct a joint-significance
test of moderated mediation. Muller et al. (2005) recommend using variables
that are either contrast-coded or centered. Using \code{mdt_moderated} with
a DV, a mediator, or a moderator that is neither contrast-coded nor
centered will give a warning message.
}

\references{
Muller, D., Judd, C. M., & Yzerbyt, V. Y. (2005). When moderation
is mediated and mediation is moderated. \emph{Journal of Personality and
Social Psychology}, 89(6), 852-863. doi: 10.1037/0022-3514.89.6.852

Yzerbyt, V., Muller, D., Batailler, C., & Judd, C. M. (2018). New
recommendations for testing indirect effects in mediational models: The
need to report and test component paths. \emph{Journal of Personality and
Social Psychology}, \emph{115}(6), 929–943. doi: 10.1037/pspa0000132
}
\seealso{
Other mediation models: \code{\link{mdt_simple}},
  \code{\link{mdt_within}}
}
\concept{mediation models}
