% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual_acuity.R
\docType{class}
\name{VAObject-class}
\alias{VAObject-class}
\alias{[,VAObject,ANY,ANY,ANY-method}
\alias{[,VAObject-method}
\alias{print,VAObject-method}
\alias{show,VAObject-method}
\alias{summary,VAObject-method}
\title{An S4 class to hold visual acuity data}
\usage{
\S4method{[}{VAObject,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{print}{VAObject}(x, ...)

\S4method{show}{VAObject}(object)

\S4method{summary}{VAObject}(object, weightbest = TRUE, w = c(0.75,
  0.25))
}
\arguments{
\item{x}{the object to subset}

\item{i}{the rows to subset (optional)}

\item{j}{the columns to subset (optional)}

\item{...}{Additional arguments passed to lower functions}

\item{drop}{should be missing}

\item{object}{A VAObject class object}

\item{weightbest}{Logical whether to upweight the best seeing eye.
Defaults to \code{TRUE}.}

\item{w}{A numeric vector of the weights, first for the best seeing
then the worst seeing eye. Defaults to \code{c(.75, .25)}.}
}
\description{
A class to hold Visual Acuity data for the oculus sinister (OS; left eye)
and oculus dexter (OD; right eye)
}
\section{Methods (by generic)}{
\itemize{
\item \code{[}: extract method

\item \code{print}: print method

\item \code{show}: show method

\item \code{summary}: summary method
}}

\section{Slots}{

\describe{
\item{\code{originalOS}}{the original visual acuity data for the left (ocular sinister) eye}

\item{\code{originalOD}}{the original visual acuity data for the right (ocular dexter) eye}

\item{\code{logMAROS}}{Logarithm of the minimum angle of resolution data for OS}

\item{\code{logMAROD}}{Logarithm of the minimum angle of resolution data for OD}

\item{\code{chart.values}}{the snellen values for each line of the chart used
to measure visual acuity.  Used for the linear interpolation in the
case of partially correct line readings.}

\item{\code{chart.nletters}}{the number of letters on each line of the chart
used to measure visual acuity.  Used for the linear interpolation
in the case of partially correct line readings (+2 is 2/4 of the
way to the next line if there are four letters, but only 2/6 if
there are six, etc.)}

\item{\code{zero}}{the logMAR value chosen to represent "zero" visual acuity
when creating the combined logMAR values for both eyes or taking
the arithmetic mean.}
}}

