% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{modelPerformance}
\alias{modelPerformance}
\alias{as.modelPerformance}
\alias{is.modelPerformance}
\alias{modelPerformance.lm}
\title{Return Indices of Model Performance}
\usage{
modelPerformance(object, ...)

as.modelPerformance(x)

is.modelPerformance(x)

\method{modelPerformance}{lm}(object, ...)
}
\arguments{
\item{object}{A fitted model object. The class of the model
determines which specific method is called.}

\item{...}{Additional arguments passed to specific methods.}

\item{x}{A object (e.g., list or a modelPerformance object) to
test or attempt coercing to a modelPerformance object.}
}
\value{
A \code{data.table} with results.

A list with a \code{data.table} with the following elements:
  \describe{
  \item{Model}{A character string indicating the model type, here lm}
  \item{N_Obs}{The number of observations}
  \item{AIC}{Akaike Information Criterion}
  \item{BIC}{Bayesian Information Criterion}
  \item{LL}{log likelihood}
  \item{LLDF}{log likelihood degrees of freedom}
  \item{Sigma}{Residual variability}
  \item{R2}{in sample variance explained}
  \item{F2}{Cohen's F2 effect size R2 / (1 - R2)}
  \item{AdjR2}{adjusted variance explained}
  \item{F}{F value for overall model significance test}
  \item{FNumDF}{numerator degrees of freedom for F test}
  \item{FDenDF}{denominator degrees of freedom for F test}
  \item{P}{p-value for overall model F test}
  }
}
\description{
Generic function. Generally returns things like
fit indices, absolute error metrics, tests of
overall model significance.
}
\details{
For \code{lm} class objects, return number of observations,
AIC, BIC, log likelihood, R2, overall model F test, and p-value.
}
\examples{
modelPerformance(lm(mpg ~ qsec * hp, data = mtcars))

modelPerformance(lm(mpg ~ hp, data = mtcars))

\dontrun{
modelPerformance(lm(mpg ~ 0 + hp, data = mtcars))
modelPerformance(lm(mpg ~ 1, data = mtcars))
modelPerformance(lm(mpg ~ 0, data = mtcars))
}
}
