% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{KHQ5D_data}
\alias{KHQ5D_data}
\title{KHQ five dimension data}
\format{
This data frame has 30 rows and the following 5 columns:
\describe{
\item{RL}{Role Limitations:
1. Your bladder problem does not affect your household tasks, job, or normal daily activities outside the home;
2. Your bladder problem slightly affects your household tasks, job, or normal daily activities outside the home;
3. Your bladder problem moderately affects your household tasks, job, or normal daily activities outside the home;
4. Your bladder problem affects your household tasks, job, or normal daily activities outside the home a lot.}
\item{PL}{Physical Limitations:
1. Your bladder problem does not affect your physical activities or ability to travel;
2. Your bladder problem slightly affects your physical activities or ability to travel;
3. Your bladder problem moderately affects your physical activities or ability to travel;
4. Your bladder problem affects your physical activities or ability to travel a lot.}
\item{SL}{Social Limitations:
1. Your bladder problem does not limit your ability to see/visit friends or affect your family life;
2. Your bladder problem slightly limits your ability to see/visit friends or affects your family life;
3. Your bladder problem moderately limits your ability to see/visit friends or affects your family life;
4. Your bladder problem limits your ability to see/visit friends or affects your family life a lot.}
\item{E}{Emotions:
1. Your bladder problem does not make you feel depressed or anxious and nervous;
2. Your bladder problem makes you feel slightly depressed or anxious and nervous;
3. Your bladder problem makes you feel moderately depressed or anxious and nervous;
4. Your bladder problem makes you feel depressed or anxious and nervous a lot.}
\item{S}{Sleep:
1. Your bladder problem does not affect your sleep;
2. Your bladder problem slightly affects your sleep;
3. Your bladder problem moderately affects your sleep;
4. Your bladder problem affects your sleep a lot.}
}
}
\source{
Example data
}
\usage{
KHQ5D_data
}
\description{
This data set contains an example of 30 responses of the KHQ5D.
}
\examples{
\donttest{
KHQ5D(scores = KHQ5D_data, country = "UK", type = "SG",
  author = "Brazier", year = 2008, source = "KHQ",
  ignore.invalid = TRUE)

KHQ5D(scores = KHQ5D_data, country = "UK", type = "SG",
  author = "Brazier", year = 2008, source = "KHQ",
  save.xlsx = FALSE, filename = "Res_KHQ5D_uti_ind.xlsx",
  sheetName = "Utility_Index", ignore.invalid = TRUE)
}

}
\references{
Brazier J, Czoski-Murray C, Roberts J, Brown M, Symonds T, Kelleher C.
Estimation of a preference-based index from a condition-specific measure:
the King's Health Questionnaire. Med Decis Making. 2008 Jan-Feb;28(1):113-26.
doi:10.1177/0272989X07301820.
\href{https://pubmed.ncbi.nlm.nih.gov/17641139/}{PubMed}
}
\keyword{dataset}
