% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KPC.R
\name{Klin}
\alias{Klin}
\title{A near linear time analogue of KMAc}
\usage{
Klin(
  Y,
  X,
  k = kernlab::rbfdot(1/(2 * stats::median(stats::dist(Y))^2)),
  Knn = 1
)
}
\arguments{
\item{Y}{a matrix of response (n by dy)}

\item{X}{a matrix of predictors (n by dx)}

\item{k}{a function \eqn{k(y, y')} of class \code{kernel}. It can be the kernel implemented in \code{kernlab} e.g. \code{rbfdot(sigma = 1)}, \code{vanilladot()}}

\item{Knn}{the number of K-nearest neighbor to use; or "MST".}
}
\value{
The algorithm returns a real number `Klin': an empirical kernel measure of association which can be computed in near linear time when K-NN graphs are used.
}
\description{
Calculate \eqn{\hat{\eta}_n^{\mbox{lin}}} (the unconditional version of graph-based KPC) using directed K-NN graph or minimum spanning tree (MST).
The computational complexity is O(nlog(n))
}
\details{
\eqn{\hat{\eta}_n} is an estimate of the population kernel measure of association, based on data \eqn{(X_1,Y_1),\ldots ,(X_n,Y_n)\sim \mu}.
For K-NN graph, \eqn{\hat{\eta}_n} can be computed in near linear time (in \eqn{n}).
In particular,
\deqn{\hat{\eta}_n^{\mbox{lin}}:=\frac{n^{-1}\sum_{i=1}^n d_i^{-1}\sum_{j:(i,j)\in\mathcal{E}(G_n)} k(Y_i,Y_j)-(n-1)^{-1}\sum_{i=1}^{n-1} k(Y_i,Y_{i+1})}{n^{-1}\sum_{i=1}^n k(Y_i,Y_i)-(n-1)^{-1}\sum_{i=1}^{n-1} k(Y_i,Y_{i+1})}},
where all symbols have their usual meanings as in the definition of \eqn{\hat{\eta}_n}.
Euclidean distance is used for computing the K-NN graph and the MST.
}
\examples{
library(kernlab)
Klin(Y = rnorm(100), X = rnorm(100), k = rbfdot(1), Knn = 1)
}
\references{
Deb, N., P. Ghosal, and B. Sen (2020), “Measuring association on topological spaces using kernels and geometric graphs” <arXiv:2010.01768>.
}
\seealso{
\code{\link{KPCgraph}}, \code{\link{KMAc}}
}
