% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kg_use_palette.R
\name{scale_fill_kg}
\alias{scale_fill_kg}
\title{Use Color fills on 'ggplot2'}
\usage{
scale_fill_kg(
  name = "Sapporo_Sta",
  alpha = 1,
  na.value = "red",
  discrete = TRUE
)
}
\arguments{
\item{name}{color palette name. (default: \code{"Sapporo_Sta"})}

\item{alpha}{The alpha transparency. Numbers range from 0-1.
see argument alpha in \code{\link[grDevices]{rgb}}.}

\item{na.value}{Color of missing value.(default: "red")}

\item{discrete}{Generate a discrete palette.
(\code{FALSE} - generate continuous palette)}
}
\value{
Create a user defined color palette for 'ggplot2'.
}
\description{
\code{scale_fill_kg} Use color palette on 'ggplot2' fills.
}
\examples{
set.seed(1)
x <- LETTERS[1:20]
y <- paste0("var", seq(1,20))
data <- expand.grid(X=x, Y=y)
data$Z <- sample(c(NA, rnorm(15)), 20, replace = TRUE)
library("ggplot2")
ggplot(data, aes(X, Y, fill= Z)) +
  geom_tile() +
  scale_fill_kg(discrete = FALSE, name = "Hanamushiro",
                alpha = 0.4, na.value = "red")
}
