#' Attach Common, Non-Masking HTML Functions
#' 
#' Calling this function will attach HTML tagging functions.
#' 
#' @seealso \code{\link{detachHTML}}
#' @export
attachHTML <- function() {
  
  if( ".html.sub" %in% search() ) {
    warning("HTML functions already attached!")
     return( invisible(NULL) )
  } else {
    myFuns <- c(
      paste( sep="", "h", 1:6),
      "tr", "td", "th", "ul", "ol", "li", "p", "span", "br", "strong", "em", "a",
      "hr", "div", "link", "script", "pre"
    )
    .html.sub <- new.env()
    for( fun in myFuns ) {
      assign( fun, get(fun, envir=get(".html")), envir=.html.sub )
    }
    
    attach( what=get(".html.sub"), name=".html.sub" )
  }
  
}

#' Detach Common, Non-Masking HTML Functions
#' 
#' Calling this function will detach the environment generated by
#' \code{attachHTML()}.
#' 
#' @seealso \code{\link{attachHTML}}
#' @export
detachHTML <- function() {
  
  if( ".html.sub" %in% search() ) {
    detach(".html.sub")
  } else {
    warning("HTML functions not attached.")
  }  
}