/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.kr.KoreanTokenizerImpl;

public class KoreanTokenizer
extends Tokenizer {
    private final KoreanTokenizerImpl scanner;
    public static final int ALPHANUM = 0;
    public static final int APOSTROPHE = 1;
    public static final int ACRONYM = 2;
    public static final int COMPANY = 3;
    public static final int EMAIL = 4;
    public static final int HOST = 5;
    public static final int NUM = 6;
    public static final int CJ = 7;
    public static final int KOROREAN = 8;
    public static final String[] TOKEN_TYPES = new String[]{"<ALPHANUM>", "<APOSTROPHE>", "<ACRONYM>", "<COMPANY>", "<EMAIL>", "<HOST>", "<NUM>", "<CJ>", "<KOREAN>"};
    private int maxTokenLength = 255;

    public KoreanTokenizer(Reader input) {
        this.input = input;
        this.scanner = new KoreanTokenizerImpl(input);
    }

    public Token next() throws IOException {
        return this.next(new Token());
    }

    public Token next(Token result) throws IOException {
        int posIncr = 1;
        if (result == null) {
            result = new Token();
        }
        int tokenType;
        while ((tokenType = this.scanner.getNextToken()) != -1) {
            if (this.scanner.yylength() <= this.maxTokenLength) {
                result.clear();
                result.setPositionIncrement(posIncr);
                this.scanner.getText(result);
                int start = this.scanner.yychar();
                result.setStartOffset(start);
                result.setEndOffset(start + result.termLength());
                if (tokenType == 8) {
                    result.setType(KoreanTokenizerImpl.TOKEN_TYPES[2]);
                } else {
                    result.setType(KoreanTokenizerImpl.TOKEN_TYPES[tokenType]);
                }
                return result;
            }
            ++posIncr;
        }
        return null;
    }

    public void reset() throws IOException {
        super.reset();
        this.scanner.yyreset(this.input);
    }

    public void reset(Reader reader) throws IOException {
        this.input = reader;
        this.reset();
    }
}

