/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.morph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.kr.morph.CompoundEntry;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.morph.WordEntry;
import org.apache.lucene.analysis.kr.utils.DictionaryUtil;

public class CompoundNounAnalyzer {
    private static int score = 1;
    private boolean exactMach = true;
    private static Pattern NUM_PATTERN = Pattern.compile("^[0-9\\.,]+$");
    private static Pattern ALPHANUM_PATTERN = Pattern.compile("^[0-9A-Za-z\\.,]+$");

    public boolean isExactMach() {
        return this.exactMach;
    }

    public void setExactMach(boolean exactMach) {
        this.exactMach = exactMach;
    }

    public List analyze(String input) throws MorphException {
        return this.analyze(input, true);
    }

    public List analyze(String input, boolean isFirst) throws MorphException {
        int len = input.length();
        if (len < 3) {
            return new ArrayList();
        }
        ArrayList outputs = new ArrayList();
        switch (len) {
            case 3: {
                this.analyze3Word(input, outputs, isFirst);
                break;
            }
            case 4: {
                this.analyze4Word(input, outputs, isFirst);
                break;
            }
            case 5: {
                this.analyze5Word(input, outputs, isFirst);
                break;
            }
            case 6: {
                this.analyze6Word(input, outputs, isFirst);
                break;
            }
            default: {
                this.analyzeLongText(input, outputs, isFirst);
            }
        }
        System.out.println("analyze:" + outputs.size());
        return outputs;
    }

    private void analyze3Word(String input, List outputs, boolean isFirst) throws MorphException {
        int[] units1 = new int[]{2, 1};
        CompoundEntry[] entries1 = this.analysisBySplited(units1, input, isFirst);
        if (entries1 != null && entries1[0].isExist() && entries1[1].isExist()) {
            outputs.addAll(Arrays.asList(entries1));
            return;
        }
        int[] units2 = new int[]{1, 2};
        CompoundEntry[] entries2 = this.analysisBySplited(units2, input, isFirst);
        if (entries2 != null && entries2[0].isExist() && entries2[1].isExist()) {
            outputs.addAll(Arrays.asList(entries2));
        }
    }

    private void analyze4Word(String input, List outputs, boolean isFirst) throws MorphException {
        int[] units0;
        CompoundEntry[] entries0;
        if (!isFirst && (entries0 = this.analysisBySplited(units0 = new int[]{1, 3}, input, isFirst)) != null && entries0[0].isExist() && entries0[1].isExist()) {
            outputs.addAll(Arrays.asList(entries0));
            return;
        }
        int[] units2 = new int[]{1, 2, 1};
        CompoundEntry[] entries2 = this.analysisBySplited(units2, input, isFirst);
        if (entries2 != null && entries2[0].isExist() && entries2[1].isExist() && entries2[2].isExist()) {
            outputs.addAll(Arrays.asList(entries2));
            return;
        }
        int[] units1 = new int[]{2, 2};
        CompoundEntry[] entries1 = this.analysisBySplited(units1, input, isFirst);
        if (entries1 != null && entries1[0].isExist() && entries1[1].isExist()) {
            outputs.addAll(Arrays.asList(entries1));
            return;
        }
        if (!this.exactMach && entries1 != null && (entries1[0].isExist() || entries1[1].isExist())) {
            outputs.addAll(Arrays.asList(entries1));
        }
    }

    private void analyze5Word(String input, List outputs, boolean isFirst) throws MorphException {
        int[] units1 = new int[]{2, 3};
        CompoundEntry[] entries1 = this.analysisBySplited(units1, input, isFirst);
        if (entries1 != null && entries1[0].isExist() && entries1[1].isExist()) {
            outputs.addAll(Arrays.asList(entries1));
            return;
        }
        int[] units2 = new int[]{3, 2};
        CompoundEntry[] entries2 = this.analysisBySplited(units2, input, isFirst);
        if (entries2 != null && entries2[0].isExist() && entries2[1].isExist()) {
            outputs.addAll(Arrays.asList(entries2));
            return;
        }
        int[] units_1 = new int[]{4, 1};
        CompoundEntry[] entries_1 = this.analysisBySplited(units_1, input, isFirst);
        if (entries_1 != null && entries_1[0].isExist() && entries_1[1].isExist()) {
            outputs.addAll(Arrays.asList(entries_1));
            return;
        }
        int[] units3 = new int[]{2, 2, 1};
        CompoundEntry[] entries3 = this.analysisBySplited(units3, input, isFirst);
        if (entries3 != null && entries3[0].isExist() && entries3[1].isExist() && entries3[2].isExist()) {
            outputs.addAll(Arrays.asList(entries3));
            return;
        }
        int[] units4 = new int[]{2, 1, 2};
        CompoundEntry[] entries4 = this.analysisBySplited(units4, input, isFirst);
        if (entries4 != null && entries4[0].isExist() && entries4[1].isExist() && entries4[2].isExist()) {
            outputs.addAll(Arrays.asList(entries4));
            return;
        }
        if (!this.exactMach && entries1 != null && (entries1[0].isExist() || entries1[1].isExist())) {
            outputs.addAll(Arrays.asList(entries1));
            return;
        }
        if (!this.exactMach && entries2 != null && (entries2[0].isExist() || entries2[1].isExist())) {
            outputs.addAll(Arrays.asList(entries2));
            return;
        }
        if (!this.exactMach && entries3 != null && (entries3[0].isExist() || entries3[1].isExist())) {
            outputs.addAll(Arrays.asList(entries3));
        }
        if (!this.exactMach && entries4 != null && (entries4[0].isExist() || entries4[2].isExist())) {
            outputs.addAll(Arrays.asList(entries4));
        }
    }

    private void analyze6Word(String input, List outputs, boolean isFirst) throws MorphException {
        int[] units2 = new int[]{3, 3};
        CompoundEntry[] entries2 = this.analysisBySplited(units2, input, isFirst);
        if (entries2 != null && entries2[0].isExist() && entries2[1].isExist()) {
            outputs.addAll(Arrays.asList(entries2));
            return;
        }
        int[] units1 = new int[]{2, 2, 2};
        CompoundEntry[] entries1 = this.analysisBySplited(units1, input, isFirst);
        if (entries1 != null && entries1[0].isExist() && entries1[1].isExist() && entries1[2].isExist()) {
            outputs.addAll(Arrays.asList(entries1));
            return;
        }
        int[] units3 = new int[]{2, 4};
        CompoundEntry[] entries3 = this.analysisBySplited(units3, input, isFirst);
        if (entries3 != null && entries3[0].isExist() && entries3[1].isExist()) {
            outputs.addAll(Arrays.asList(entries3));
            return;
        }
        int[] units4 = new int[]{4, 2};
        CompoundEntry[] entries4 = this.analysisBySplited(units4, input, isFirst);
        if (entries4 != null && entries4[0].isExist() && entries4[1].isExist()) {
            outputs.addAll(Arrays.asList(entries4));
            return;
        }
        if (!this.exactMach && entries1 != null && this.canCompound(entries1, 2 * score)) {
            outputs.addAll(Arrays.asList(entries1));
            return;
        }
        if (!this.exactMach && entries2 != null && (entries2[0].isExist() || entries2[1].isExist())) {
            outputs.addAll(Arrays.asList(entries2));
            return;
        }
        if (!this.exactMach && entries3 != null && (entries3[0].isExist() || entries3[1].isExist())) {
            outputs.addAll(Arrays.asList(entries3));
            return;
        }
        if (!this.exactMach && entries4 != null && (entries4[0].isExist() || entries4[1].isExist())) {
            outputs.addAll(Arrays.asList(entries4));
        }
    }

    private void analyzeLongText(String input, List outputs, boolean isFirst) throws MorphException {
        if (this.exactMach) {
            return;
        }
        String[] words = this.splitByLongestWord(input);
        if (words == null) {
            return;
        }
        if (isFirst && words[0] != null && words[0].length() == 1 && !DictionaryUtil.existPrefix(words[0])) {
            return;
        }
        if (words[2] != null && words[2].length() == 1 && !DictionaryUtil.existSuffix(words[2])) {
            return;
        }
        CompoundEntry e1 = null;
        List list1 = null;
        boolean success1 = false;
        if (words[0] != null && !(e1 = this.analyzeSingle(words[0])).isExist()) {
            list1 = this.analyze(words[0], false);
        }
        CompoundEntry e2 = null;
        List list2 = null;
        boolean success2 = false;
        if (words[2] != null && !(e2 = this.analyzeSingle(words[2])).isExist()) {
            list2 = this.analyze(words[2], false);
        }
        if (list1 != null && list1.size() > 0) {
            outputs.addAll(list1);
        } else if (e1 != null) {
            outputs.add(e1);
        }
        outputs.add(this.analyzeSingle(words[1]));
        if (list2 != null && list2.size() > 0) {
            outputs.addAll(list2);
        } else if (e2 != null) {
            outputs.add(e2);
        }
    }

    private String[] splitByLongestWord(String input) throws MorphException {
        int pos = 0;
        String lngWord = "";
        int last = input.length() - 1;
        boolean ftry = true;
        int i = 0;
        while (i < last) {
            String word = this.lookupWord(input.substring(i), ftry);
            if (word != null && lngWord.length() < word.length()) {
                lngWord = word;
                pos = i;
                if (i == 0) {
                    ftry = false;
                } else {
                    Matcher m = ALPHANUM_PATTERN.matcher(input.substring(0, i));
                    if (!m.find()) {
                        ftry = false;
                    }
                }
            }
            ++i;
        }
        if ("".equals(lngWord)) {
            return null;
        }
        String[] results = new String[3];
        int end = pos + lngWord.length();
        if (pos != 0) {
            results[0] = input.substring(0, pos);
        }
        results[1] = lngWord;
        if (end < input.length()) {
            results[2] = input.substring(end);
        }
        return results;
    }

    private String lookupWord(String text, boolean ftry) throws MorphException {
        String word = null;
        String prev = null;
        int i = 2;
        while (i <= text.length()) {
            word = text.substring(0, i);
            Iterator prefix = DictionaryUtil.findWithPrefix(word);
            if (!prefix.hasNext()) {
                if (prev == null) {
                    return null;
                }
                WordEntry entry = DictionaryUtil.getWordExceptVerb(prev);
                if (entry != null) {
                    String str = entry.getWord();
                    String suffix = text.substring(i - 1, i);
                    if (ftry && DictionaryUtil.existSuffix(suffix)) {
                        return null;
                    }
                    return str;
                }
                return null;
            }
            prev = word;
            ++i;
        }
        WordEntry entry = DictionaryUtil.getWordExceptVerb(text);
        if (entry != null) {
            return entry.getWord();
        }
        return null;
    }

    private CompoundEntry[] analysisBySplited(int[] units, String input, boolean isFirst) throws MorphException {
        CompoundEntry[] entries = new CompoundEntry[units.length];
        int pos = 0;
        String prev = null;
        int i = 0;
        while (i < units.length) {
            String str = input.substring(pos, pos + units[i]);
            if (i != 0 && !this.validCompound(prev, str, isFirst && i == 1)) {
                return null;
            }
            entries[i] = this.analyzeSingle(str);
            pos += units[i];
            prev = str;
            ++i;
        }
        return entries;
    }

    private boolean canCompound(CompoundEntry[] entries, int thredhold) {
        int achived = 0;
        int i = 0;
        while (i < entries.length) {
            if (entries[i].isExist()) {
                achived += score;
            }
            ++i;
        }
        return achived >= thredhold;
    }

    private CompoundEntry analyzeSingle(String input) throws MorphException {
        boolean success = false;
        int score = 30;
        int ptn = 1;
        int pos = 78;
        if (input.length() == 1) {
            return new CompoundEntry(input, 0, true, (char)pos);
        }
        WordEntry entry = DictionaryUtil.getWordExceptVerb(input);
        if (entry != null) {
            score = 100;
            if (entry.getFeature(0) != '1') {
                ptn = 21;
                pos = 90;
            }
        }
        return new CompoundEntry(input, 0, score == 100, (char)pos);
    }

    private boolean validCompound(String before, String after, boolean isFirst) throws MorphException {
        List<CompoundEntry> compounds;
        WordEntry entry2;
        List<CompoundEntry> compounds2;
        if (isFirst && before.length() == 1 && !DictionaryUtil.existPrefix(before)) {
            return false;
        }
        if (after.length() == 1 && !DictionaryUtil.existSuffix(after)) {
            return false;
        }
        WordEntry entry1 = DictionaryUtil.getUncompound(String.valueOf(before) + after);
        if (entry1 != null && before.equals((compounds2 = entry1.getCompounds()).get(0).getWord()) && after.equals(compounds2.get(1).getWord())) {
            return false;
        }
        WordEntry wordEntry = entry2 = after.length() == 1 ? null : DictionaryUtil.getUncompound(after);
        return entry2 == null || !"*".equals((compounds = entry2.getCompounds()).get(0).getWord()) || !after.equals(compounds.get(1).getWord());
    }
}

