% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LaPSO.R
\name{LaPSO}
\alias{LaPSO}
\title{Particle Swarm Optimization for LHD}
\usage{
LaPSO(
  n,
  k,
  m = 10,
  N = 10,
  SameNumP = 0,
  SameNumG = n/4,
  p0 = 1/(k - 1),
  OC = "phi_p",
  p = 15,
  q = 1,
  maxtime = 5
)
}
\arguments{
\item{n}{A positive integer, which stands for the number of rows (or run size).}

\item{k}{A positive integer, which stands for the number of columns (or factor size).}

\item{m}{A positive integer, which stands for the number of particles. The default is set to be 10.}

\item{N}{A positive integer, which stands for the number of iterations. The default is set to be 10.}

\item{SameNumP}{A non-negative integer, which stands for how many elements in current column of current particle LHD should be the same as corresponding Personal Best. SameNumP=0, 1, 2, ..., n, and 0 means to skip the "exchange".  The default is set to be 0.}

\item{SameNumG}{A non-negative integer, which stands for how many elements in current column of current particle LHD should be the same as corresponding Global Best. SameNumP=0, 1, 2, ..., n, and 0 means to skip the "exchange".  The default is set to be \code{n}/4. \code{SameNumP} and \code{SameNumG} cannot be 0 at the same time.}

\item{p0}{A probability of exchanging two randomly selected elements in current column of current particle LHD. The default is set to be 1/(\code{k} - 1).}

\item{OC}{An optimality criterion. The default setting is "phi_p", and it could be one of the following: "phi_p", "AvgAbsCor", "MaxAbsCor", "MaxProCriterion".}

\item{p}{A positive integer, which is the parameter in the phi_p formula, and \code{p} is prefered to be large. The default is set to be 15.}

\item{q}{The default is set to be 1, and it could be either 1 or 2. If \code{q} is 1, \code{dij} is the Manhattan (rectangular) distance. If \code{q} is 2, \code{dij} is the Euclidean distance.}

\item{maxtime}{A positive number, which indicates the expected maximum CPU time given by user, and it is measured by minutes. For example, maxtime=3.5 indicates the CPU time will be no greater than three and half minutes. The default is set to be 5.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{k} LHD. Here are some general suggestions about the parameters: \itemize{
\item \code{SameNumP} is approximately \code{n}/2 when \code{SameNumG} is 0.
\item \code{SameNumG} is approximately \code{n}/4 when \code{SameNumP} is 0.
\item \code{p0} * (\code{k} - 1) = 1 to 2 is often sufficient. So \code{p0} = 1/(\code{k} - 1) to 2/(\code{k} - 1).
}
}
\description{
\code{LaPSO} returns an LHD matrix generated by particle swarm optimization algorithm (PSO)
}
\examples{
#generate a 5 by 3 maximin distance LHD with the default setting
try=LaPSO(n=5,k=3)
try
phi_p(try)   #calculate the phi_p of "try".

#Another example
#generate a 8 by 4 nearly orthogonal LHD
try2=LaPSO(n=8,k=4,OC="AvgAbsCor")
try2
AvgAbsCor(try2)  #calculate the average absolute correlation.
}
\references{
Chen, R.-B., Hsieh, D.-N., Hung, Y., and Wang, W. (2013) Optimizing Latin hypercube designs by particle swarm. \emph{Stat. Comput.}, \strong{23}, 663-676.
}
