% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AQSys.mrchk.R
\name{AQSys.tielines}
\alias{AQSys.tielines}
\title{Merchuk's Method - Tieline's Composition Calculation}
\usage{
\method{AQSys}{tielines}(XYdt, Xm, Ym, Vt, Vb, dyt, dyb, ...)
}
\arguments{
\item{XYdt}{- Binodal Experimental data that will be used in the nonlinear fit}

\item{Xm}{- Component X's concentration in the tieline's global composition.}

\item{Ym}{- Component Y's concentration in the tieline's global composition.}

\item{Vt}{- Tieline's TOP phase volume.}

\item{Vb}{- Tieline's BOTTOM phase volume.}

\item{dyt}{- Tieline's TOP phase density}

\item{dyb}{- Tieline's BOTTOM phase density}

\item{...}{Additional optional arguments. None are used at present.}
}
\value{
The function returns the Critical Point (X,Y), Tieline Length (TLL), Tieline's Equivolume point (xVRe2o,yVRe2o),
and Tieline's Slope.
}
\description{
Merchuk et al. described a very straightforward method to calculate the concentration of each component in the
tieline giving only its global composition and phase's properties (such as volume and density).
}
\details{
Using the binodal data, the global composition of a chosen tieline and its phases properties (more precisely each
phase density and volume)
}
\examples{
\dontrun{
AQSys.tielines(XYdt,Xm,Ym,Vt,Vb,dyt,dyb)
}
}

