% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSys.mrchk.R
\name{AQSys.crpt}
\alias{AQSys.crpt}
\title{Merchuk's Method - Critical Point Calculation}
\usage{
\method{AQSys}{crpt}(XYdt, tldata, ...)
}
\arguments{
\item{XYdt}{- Binodal Experimental data that will be used in the nonlinear fit}

\item{tldata}{- A data.frame with two columns containing a set of Tieline's Slopes (S)
and its bottom-rich component composition in the bottom phase (XB).}

\item{...}{Additional optional arguments. None are used at present.}
}
\value{
(XCrit,YCrit) - The function returns Tieline's Critical Point Composition
}
\description{
Merchuk et al. described a very straightforward method to calculate the critical composition of a given Binodal
curve and its Tielines.
}
\details{
Using the binodal data, tieline's Slopes (S), the composition of bottom-rich component in the bottom phase (XB)
and an equation which stablish a relatioship between them, this function returns the critical composition of the binodal
under study. When used within a iterative function, mrchk.tielines() can be used to obtain TLL and S and therefore
calculate the critical composition.
}
\examples{
\dontrun{
AQSys.crpt(XYdt,tldata)
}
}
