% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.lmm}
\alias{autoplot.lmm}
\title{Display Fitted values of Linear Mixed Models}
\usage{
\method{autoplot}{lmm}(
  object,
  obs.alpha = 0,
  obs.size = c(2, 0.5),
  at = NULL,
  time.var = NULL,
  color = TRUE,
  ci = TRUE,
  ci.alpha = NA,
  plot = TRUE,
  ylim = NULL,
  mean.size = c(3, 1),
  size.text = 16,
  position.errorbar = "identity",
  ...
)
}
\arguments{
\item{object}{a \code{lmm} object.}

\item{obs.alpha}{[numeric, 0-1] When not NA, transparency parameter used to display the original data by cluster.}

\item{obs.size}{[numeric vector of length 2] size of the point and line for the original data.}

\item{at}{[data.frame] values for the covariates at which to evaluate the fitted values.}

\item{time.var}{[character] x-axis variable for the plot.}

\item{color}{[character] name of the variable in the dataset used to color the curve.}

\item{ci}{[logical] should confidence intervals be displayed?}

\item{ci.alpha}{[numeric, 0-1] When not NA, transparency parameter used to display the confidence intervals.}

\item{plot}{[logical] should the plot be displayed?}

\item{ylim}{[numeric vector of length 2] the lower and higher value of the vertical axis.}

\item{mean.size}{[numeric vector of length 2] size of the point and line for the mean trajectory.}

\item{size.text}{[numeric, >0] size of the font used to display text.}

\item{position.errorbar}{[character] relative position of the errorbars.}

\item{...}{arguments passed to the predict method.}
}
\value{
A list with two elements \itemize{
\item \code{data}: data used to create the graphical display.
\item \code{plot}: ggplot object.
}
}
\description{
Display Fitted values of Linear Mixed Models
}
\examples{
if(require(ggplot2)){

#### simulate data in the long format ####
set.seed(10)
dL <- sampleRem(100, n.times = 3, format = "long")
dL$X1 <- as.factor(dL$X1)

#### fit Linear Mixed Model ####
eCS.lmm <- lmm(Y ~ visit + X1,
               repetition = ~visit|id, structure = "CS", data = dL, df = FALSE)

autoplot(eCS.lmm)
autoplot(eCS.lmm, plot = FALSE)$plot + facet_wrap(~X1)
}
}
\seealso{
\code{\link{plot.lmm}} for other graphical display (residual plots, partial residual plots).
}
