% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R, R/plot.R
\name{autoplot.lmm}
\alias{autoplot.lmm}
\alias{plot.lmm}
\title{Graphical Display For Linear Mixed Models}
\usage{
\method{autoplot}{lmm}(
  object,
  type = "fit",
  type.residual = "normalized",
  obs.alpha = 0,
  obs.size = c(2, 0.5),
  at = NULL,
  time.var = NULL,
  color = TRUE,
  ci = TRUE,
  ci.alpha = 0.25,
  ylim = NULL,
  mean.size = c(3, 1),
  size.text = 16,
  position.errorbar = "identity",
  ...
)

\method{plot}{lmm}(x, ...)
}
\arguments{
\item{object, x}{a \code{lmm} object.}

\item{type}{[character] the type of plot \itemize{
\item \code{"fit"}: fitted values over repetitions.
\item \code{"qqplot"}: quantile quantile plot of the normalized residuals
\item \code{"correlation"}: residual correlation over repetitions
\item \code{"scatterplot"}: normalized residuals vs. fitted values (diagnostic for missing non-linear effects),
\item \code{"scatterplot2"}: square root of the normalized residuals vs. fitted values (diagnostic for heteroschedasticity),
\item \code{"partial"}: partial residual plot.
}}

\item{type.residual}{[character] the type of residual to be used. Not relevant for \code{type="fit"}.
By default, normalized residuals are used except when requesting a partial residual plot.}

\item{obs.alpha}{[numeric, 0-1] When not NA, transparency parameter used to display the original data by cluster.}

\item{obs.size}{[numeric vector of length 2] size of the point and line for the original data.}

\item{at}{[data.frame] values for the covariates at which to evaluate the fitted values.}

\item{time.var}{[character] x-axis variable for the plot.}

\item{color}{[character] name of the variable in the dataset used to color the curve.}

\item{ci}{[logical] should confidence intervals be displayed?}

\item{ci.alpha}{[numeric, 0-1] When not NA, transparency parameter used to display the confidence intervals.}

\item{ylim}{[numeric vector of length 2] the lower and higher value of the vertical axis.}

\item{mean.size}{[numeric vector of length 2] size of the point and line for the mean trajectory.}

\item{size.text}{[numeric, >0] size of the font used to display text.}

\item{position.errorbar}{[character] relative position of the errorbars.}

\item{...}{arguments passed to the \code{predict.lmm} or \code{autoplot.residual_lmm} functions.}
}
\value{
A list with two elements \itemize{
\item \code{data}: data used to create the graphical display.
\item \code{plot}: ggplot object.
}
}
\description{
Display fitted values or residual plot for the mean, variance, and correlation structure.
Can also display quantile-quantile plot relative to the normal distribution.
}
\section{Functions}{
\itemize{
\item \code{plot(lmm)}: Graphical Display For Linear Mixed Models

}}
\examples{
if(require(ggplot2)){

#### simulate data in the long format ####
set.seed(10)
dL <- sampleRem(100, n.times = 3, format = "long")
dL$X1 <- as.factor(dL$X1)

#### fit Linear Mixed Model ####
eCS.lmm <- lmm(Y ~ visit + X1,
               repetition = ~visit|id, structure = "CS", data = dL, df = FALSE)

plot(eCS.lmm, type = "fit")
autoplot(eCS.lmm, type = "fit")$plot + facet_wrap(~X1)
plot(eCS.lmm, type = "qqplot") ## engine.qqplot = "qqtest"
plot(eCS.lmm, type = "qqplot", engine.qqplot = "qqtest")
plot(eCS.lmm, type = "correlation") 
plot(eCS.lmm, type = "scatterplot") 
plot(eCS.lmm, type = "scatterplot2") 
plot(eCS.lmm, type = "partial", type.residual = "visit") 
plot(eCS.lmm, type = "partial", type.residual = "X1") 
}
}
\seealso{
\code{\link{plot.lmm}} for other graphical display (residual plots, partial residual plots).
}
