% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableImportanceTable.R
\name{VariableImportanceTable}
\alias{VariableImportanceTable}
\title{Table comparing the feature importance for tree-based learning methods.}
\usage{
VariableImportanceTable(DT = NULL, RF = NULL, GBM = NULL)
}
\arguments{
\item{DT}{A fitted decision tree model object}

\item{RF}{A fitted random forest model object}

\item{GBM}{A fitted gradient boosting model object}
}
\value{
This function returns a data frame that compares the feature importance from different tree-based machine learning methods. These measures are computed via the caret package.
}
\description{
Table comparing the feature importance for tree-based learning methods.
}
\examples{
\donttest{
library(gbm)
colnames(training)[14] <- "perf"
ensemblist <- TreeModels(traindata = training,
methodlist = c("dt", "rf","gbm"),checkprogress = TRUE)

VariableImportanceTable(DT = ensemblist$ModelObject$rpart,
RF = ensemblist$ModelObject$ranger,GBM = ensemblist$ModelObject$gbm)

VariableImportanceTable(DT = ensemblist$ModelObject$rpart,
RF = ensemblist$ModelObject$ranger)

VariableImportanceTable(DT = ensemblist$ModelObject$rpart)
}
}
