% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_input.R
\name{point_sets_from_tiffs}
\alias{point_sets_from_tiffs}
\title{point_sets_from_tiffs}
\usage{
point_sets_from_tiffs(
  image_dir = NULL,
  pattern = NULL,
  image.size = NULL,
  sample.size = NULL,
  sample.first = FALSE,
  min.cardinality = NULL,
  max.cardinality = NULL,
  crop.size = NULL
)
}
\arguments{
\item{image_dir}{path to a directory containing the TIFF files.}

\item{pattern}{regular expression, select images whose file path matches the given pattern.}

\item{image.size}{vector of length 3 containing the size of the images along each dimension, e.g. c(40,40,40).}

\item{sample.size}{if set, selects this number of images at random. A sample size larger than the available number of samples produces a warning and is ignored.}

\item{sample.first}{if TRUE, samples are selected before applying any eventual filtering. This is more efficient as it avoids reading all data files.}

\item{min.cardinality}{if set, filter out all point sets with less than the specified number of points.}

\item{max.cardinality}{if set, filter out all point sets with more than the specified number of points.}

\item{crop.size}{vector of length 3 containing the desired reduced size of the images along each dimension, e.g. c(30,30,30).}
}
\value{
a list with two elements:
  \itemize{
    \item point.sets: a list of point sets as matrices with columns x,y,z and 
    \item file.names: a vector of paths to the TIFF files from which the point sets were extracted.
  }
}
\description{
Read in single molecule localization events from a series of 3D images in TIFF files where each image file
represents a point set.
}
\examples{
data.dir <- system.file("test_data/img", package = "LOMAR", mustWork = TRUE) 
point_sets <- point_sets_from_tiffs(image_dir = data.dir, pattern = "\\\\.tiff?$",
 image.size = c(64, 64, 4), min.cardinality = 10)
}
