% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_tests.R
\name{gamma_shape_one_sample}
\alias{gamma_shape_one_sample}
\title{Test the shape parameter of a gamma distribution.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
gamma_shape_one_sample(x, shape, alternative = "two.sided", conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector of at least 50 data values.}

\item{shape}{a number indicating the tested value of the shape parameter.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the likelihood interval.}
}
\value{
An S3 class containing the test statistic, p value, likelihood based confidence interval, and alternative
hypothesis.
}
\description{
Test the shape parameter of a gamma distribution.
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rgamma(100, shape = 1, scale = 2)
gamma_shape_one_sample(x, 1, "two.sided")

# Null is false
set.seed(1)
x <- rgamma(100, shape = 3, scale = 2)
gamma_shape_one_sample(x, 1, "greater")
}
