% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDE_simulate.R
\name{IGBM_simulate}
\alias{IGBM_simulate}
\title{Simulate the inhomogeneous geometric Brownian motion (IGBM) stochastic process through Monte Carlo simulation}
\usage{
IGBM_simulate(n, t, reversion_rate, sigma, equilibrium, S0, dt)
}
\arguments{
\item{n}{The total number of price paths to simulate}

\item{t}{The forecasting period, in years}

\item{reversion_rate}{The reversion rate term of the IGBM process}

\item{sigma}{The volatility term of the IGBM process}

\item{equilibrium}{The equilibrium term of the IGBM process}

\item{S0}{The initial value of the underlying asset}

\item{dt}{The discrete time step of observations, in years

A stochastic process S(t) is an IGBM that follows the following continuous-time stochastic differential equation:
\deqn{ dS(t) = reversion_rate(equilibrium - S(t)) dt + \sigma dW(t)}{dS(t) = reversion_rate(equilibrium - S(t)) dt + sigma dW(t)}

Where 'reversion_rate' is the rate of reversion term, 'equilibrium' is the equilibrium value the process reverts towards, \eqn{\sigma}{'sigma'} the volatility term and \eqn{W_{t}}{W(t)} is defined as a Weiner process.}
}
\value{
A matrix of simulated price paths of the IGBM process. Each column corresponds to a simulated price path, and each
row corresponds to a simulated observed price of the simulated price paths at each discrete time period.
}
\description{
The inhomogeneous geometric Brownian motion, also known as the integrated GBM process, is a member of the general affine class of stochastic process that has been reported to be well suited for modelling energy prices.
The \code{IGBM_simulate} function utilizes antithetic variates as a simple variance reduction technique.
}
\examples{
## 100 simulations of 1 year of monthly price paths:
Simulated <- IGBM_simulate(n = 100,
                         t = 1,
                         reversion_rate = 1,
                         sigma = 0.2,
                         equilibrium = 100,
                         S0 = 100,
                         dt = 1/12)
}
