% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G_delta_alpha.R
\name{G_delta_alpha}
\alias{G_delta_alpha}
\alias{G_2delta_2alpha}
\alias{G_delta}
\title{Heavy tail transformation for Lambert W random variables}
\usage{
G_delta_alpha(u, delta = 0, alpha = 1)

G_delta(u, delta = 0)

G_2delta_2alpha(u, delta = c(0, 0), alpha = c(1, 1))
}
\arguments{
\item{u}{a numeric vector of real values.}

\item{delta}{heavy tail parameter; default \code{delta = 0}, which implies
\code{G_delta_alpha(u) = u}.}

\item{alpha}{exponent in \eqn{(u^2)^{\alpha}}; default \code{alpha = 1}
(Tukey's h).}
}
\value{
numeric; same dimension/size as \code{u}.
}
\description{
Heavy-tail Lambert W RV transformation: \eqn{G_{\delta, \alpha}(u) = u
\exp(\frac{\delta}{2} (u^2)^{\alpha})}. Reduces to Tukey's h distribution
 for \eqn{\alpha = 1} (\code{\link{G_delta}}) and Gaussian input.
}
\keyword{math}
