% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RLum.Results-class.R
\docType{class}
\name{RLum.Results-class}
\alias{RLum.Results-class}
\alias{get_RLum,RLum.Results-method}
\alias{merge_RLum.Results,list-method}
\alias{set_RLum,RLum.Results-method}
\title{Class \code{"RLum.Results"}}
\usage{
\S4method{set_RLum}{RLum.Results}(class, originator, data)

\S4method{get_RLum}{RLum.Results}(object, data.object)

\S4method{merge_RLum.Results}{list}(object.list)
}
\arguments{
\item{class}{[\code{set_RLum}] \code{\link{character}} (required): name of the \code{RLum} class to create}

\item{originator}{[\code{set_RLum}] \code{\link{character}} (optional): argument to manually set
the originator.}

\item{data}{[\code{set_RLum}] \code{\link{list}} (optional): a list containing the data to be stored in the object}

\item{object}{[\code{get_RLum}] \code{\linkS4class{RLum.Results}} (required): an object of class
\code{\linkS4class{RLum.Results}} to be evaluated}

\item{data.object}{[\code{get_RLum}] \code{\link{character}}: name of the data slot to be returned}

\item{object.list}{[\code{merge_RLum.Results}] \code{\link{list}} (required): a list of \code{\linkS4class{RLum.Results}} objects}
}
\description{
Object class contains results data from functions.
}
\section{Methods (by generic)}{
\itemize{
\item \code{set_RLum}: Construction method for RLum.Results object. The slot originator is optional
and predefined as the function that calls the function set_RLum.

\item \code{get_RLum}: Accessor method for RLum.Results object. The argument data.object allows
directly accessing objects delivered within the slot data. If no
data.object is specified, a preselected object is returned. The default
return object depends on the object originator (e.g., \code{fit_LMCurve}).

\item \code{merge_RLum.Results}: merge method for RLum.Results objects. The argument object.list requires a list of RLum.Results objects.
Merging is done by appending similar elements to the first object of the input list.
}}
\section{Slots}{

\describe{
\item{\code{originator}}{Object of class "character" containing name of the producing function}

\item{\code{data}}{Object of class "list" containing output data}
}}
\note{
The class is intended to store results from functions to be used by
other functions. The data in the object should always be accessed by the
method \code{get_RLum}.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("RLum.Results", ...)}.
}

\section{Class version}{
 0.2.0
}
\examples{
showClass("RLum.Results")
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
}
\seealso{
\code{\linkS4class{RLum}}
}
\keyword{classes}
\keyword{methods}

