% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_Layout.R
\name{get_Layout}
\alias{get_Layout}
\title{Collection of layout definitions}
\usage{
get_Layout(layout)
}
\arguments{
\item{layout}{\code{\link{character}} or \code{\link{list}} object
(required): name of the layout definition to be returned. If name is
provided the respective definition is returned. One of the following
supported layout definitions is possible: \code{"default"},
\code{"journal.1"}, \code{"small"}, \code{"empty"}. User-specific layout
definitions must be provided as a list object of predefined structure, see
details.}
}
\value{
A list object with layout definitions for plot functions.
}
\description{
This helper function returns a list with layout definitions for homogeneous
plotting.
}
\details{
The easiest way to create a user-specific layout definition is perhaps to
create either an empty or a default layout object and fill/modify the
definitions (\code{user.layout <- get_Layout(data = "empty")}).
}
\section{Function version}{
 0.1 (2015-09-21 15:05:38)
}
\examples{
## read example data set
data(ExampleData.DeValues, envir = environment())

## show structure of the default layout definition
layout.default <- get_Layout(layout = "default")
str(layout.default)

## show colour definitions for Abanico plot, only
layout.default$abanico$colour

## set Abanico plot title colour to orange
layout.default$abanico$colour$main <- "orange"

## create Abanico plot with modofied layout definition
plot_AbanicoPlot(data = ExampleData.DeValues,
                 layout = layout.default)

## create Abanico plot with predefined layout "journal"
plot_AbanicoPlot(data = ExampleData.DeValues,
                 layout = "journal")
}
\author{
Michael Dietze, GFZ Potsdam (Germany)
\cr R Luminescence Package Team}

