% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_Lamothe2003.R
\name{calc_Lamothe2003}
\alias{calc_Lamothe2003}
\title{Apply fading correction after Lamothe et al., 2003}
\usage{
calc_Lamothe2003(object, dose_rate.envir, dose_rate.source, g_value,
  tc = NULL, tc.g_value = tc, verbose = TRUE, plot = TRUE, ...)
}
\arguments{
\item{object}{\linkS4class{RLum.Results} \link{data.frame} (\strong{required}): Input data for applying the
fading correction. Alow are (1) \link{data.frame} with three columns (dose, De, De error), (2)
\linkS4class{RLum.Results} object created by the function \link{analyse_SAR.CWOSL} or \link{analyse_pIRIRSequence}}

\item{dose_rate.envir}{\link{numeric} vector of length 2 (\strong{required}): Environmental dose rate in mGy/a}

\item{dose_rate.source}{\link{numeric} vector of length 2 (\strong{required}): Irradiation source dose rate in Gy/s}

\item{g_value}{\link{numeric} vector of length 2 (\strong{required}): g_value in \%/decade \emph{recalculated at the moment}
the equivalent dose was calculated, i.e. tc is either similar for the g-value measurement \strong{and} the De measurement or
needs be to recalculated (cf. \link{calc_FadingCorr}). Inserting a normalised g-value, e.g., normalised to 2-days , will
lead to wrong results}

\item{tc}{\link{numeric} (optional): time in seconds between irradiation and the prompt measurement used in the De estimation (cf. Huntley & Lamothe 2001).
If set to \code{NULL} it is assumed that tc is similar for the equivalent dose estimation and the g-value estimation}

\item{tc.g_value}{\link{numeric} (with default): the time in seconds between irradiation and the prompt measurement used for estimating the g-value.
If the g-value was normalised to, e.g., 2 days, this time in seconds (i.e., 172800) should be given here along with the time used for the
De estimation. If nothing is provided the time is set to tc, which is usual case for g-values obtained using the
SAR method and g-values that had been not normalised to 2 days. Note: If this value is not \code{NULL} the functions expects a \link{numeric} value for \code{tc}.}

\item{verbose}{\link{logical} (with default): Enables/disables terminal verbose mode}

\item{plot}{\link{logical} (with default): Enables/disables plot output}

\item{...}{further arguments passed to the function \link{plot_GrowthCurve}}
}
\value{
The function returns are graphical output produced by the function \link{plot_GrowthCurve} and
an \linkS4class{RLum.Results}.

-----------------------------------\cr
\code{[ NUMERICAL OUTPUT ]}\cr
-----------------------------------\cr

\strong{\code{RLum.Results}}-object

\strong{slot:} \strong{\code{@data}}

\tabular{lll}{
\strong{Element} \tab \strong{Type} \tab \strong{Description}\cr
\code{$data} \tab \code{data.frame} \tab the fading corrected values \cr
\code{$fit} \tab \code{nls} \tab the object returned by the dose response curve fitting \cr
}

'\strong{slot:} \strong{\code{@info}}

The original function call
}
\description{
This function applies the fading correction for the prediction of long-term fading as suggested
by Lamothe et atl., 2003. The function basically adjusts the Ln/Tn values and fit a new dose-response
curve using the function \link{plot_GrowthCurve}.
}
\section{Function version}{
 0.1.0 (2018-02-02 18:20:28)
}

\examples{

##load data
##ExampleData.BINfileData contains two BINfileData objects
##CWOSL.SAR.Data and TL.SAR.Data
data(ExampleData.BINfileData, envir = environment())

##transform the values from the first position in a RLum.Analysis object
object <- Risoe.BINfileData2RLum.Analysis(CWOSL.SAR.Data, pos=1)

##perform SAR analysis and set rejection criteria
results <- analyse_SAR.CWOSL(
object = object,
signal.integral.min = 1,
signal.integral.max = 2,
background.integral.min = 900,
background.integral.max = 1000,
verbose = FALSE,
plot = FALSE,
onlyLxTxTable = TRUE
)

##run fading correction
results_corr <- calc_Lamothe2003(
  object = results,
  dose_rate.envir =  c(1.676 , 0.180),
  dose_rate.source = c(0.184, 0.003),
  g_value =  c(2.36, 0.6),
  plot = TRUE,
  fit.method = "EXP")


} 

\section{How to cite}{
Kreutzer, S., Mercier, N. (2018). calc_Lamothe2003(): Apply fading correction after Lamothe et al., 2003. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2018). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.8.2. https://CRAN.R-project.org/package=Luminescence
}

\references{
Huntley, D.J., Lamothe, M., 2001. Ubiquity of anomalous fading in K-feldspars and the measurement
and correction for it in optical dating. Canadian Journal of Earth Sciences 38, 1093-1106.

Lamothe, M., Auclair, M., Hamzaoui, C., Huot, S., 2003.
Towards a prediction of long-term anomalous fadingof feldspar IRSL. Radiation Measurements 37,
493-498.
}
\seealso{
\link{plot_GrowthCurve}, \link{calc_FadingCorr}, \link{analyse_SAR.CWOSL}, \link{analyse_pIRIRSequence}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Université Bordeaux Montaigne (France), Norbert Mercier,
IRAMAT-CRP2A, Université Bordeaux Montaigne (France)
\cr R Luminescence Package Team}
\keyword{datagen}
