% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_04_1_RunPCA_PSI.R
\name{RunPCA.PSI}
\alias{RunPCA.PSI}
\title{Principle Component Analysis on Percent Spliced-in (PSI) Values}
\usage{
RunPCA.PSI(MarvelObject, cell.types, n.cells, features, point.size,
  event.type, seed)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject} or \code{ComputePSI} function.}

\item{cell.types}{Character string. To indicate which groups of cells that will be used for analysis. Group names should match those in \code{cell.type} column of \code{$SplicePheno} slot.}

\item{n.cells}{Numeric value. The minimum no. of cells expressing the splicing event or gene for the event or gene, respectively, to be included for analysis.}

\item{features}{Character string. Vector of \code{tran_id}s for analysis. Should match \code{tran_id} column of \code{$ValidatedSpliceFeature} slot.}

\item{point.size}{Numeric value. Size of data points on reduced dimension space.}

\item{event.type}{Character string. Indicate which splicing event type to include for analysis. Can take value \code{"SE"}, \code{"MXE"}, \code{"RI"}, \code{"A5SS"}, or \code{"A3SS"} which represents skipped-exon (SE), mutually-exclusive exons (MXE), retained-intron (RI), alternative 5' splice site (A5SS), and alternative 3' splice site (A3SS), respectively.}

\item{seed}{Numeric value.  Ensures imputed values for NA PSIs are reproducible.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{MarvelObject$PCA$PSI}. Contains both 2D scatterplot in \code{MarvelObject$PCA$PSI$Plot} and the corresponding x- and y-coordinates for each sample in \code{MarvelObject$PCA$PSI$Results}.
}
\description{
\code{RunPCA.PSI} performs principle component analysis on percent spliced-in (PSI) values.
}
\details{
This function performs principle component analysis on percent spliced-in (PSI) values and visualise cells on a reducted dimension space, i.e. 2D scatterplot.
}
\examples{
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

features <- do.call(rbind.data.frame, marvel$SpliceFeatureValidated)
features <- features$tran_id

marvel <- RunPCA.PSI(MarvelObject=marvel,
                     cell.types="all",
                     n.cells=3,
                     features=features,
                     point.size=2.5,
                     event.type="all",
                     seed=1
                     )

marvel$PCA$PSI$Results
marvel$PCA$PSI$Plot
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
