% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_03_COMPUTE_PSI_4_Compute_A3SS.R
\name{ComputePSI.A3SS}
\alias{ComputePSI.A3SS}
\title{Compute Alternative 3' Splice Site (A3SS) Percent Spliced-in (PSI) Values}
\usage{
ComputePSI.A3SS(MarvelObject, CoverageThreshold)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CreateMarvelObject} function.}

\item{CoverageThreshold}{Numeric value. Coverage threshold below which the PSI of the splicing event will be censored, i.e. annotated as missing (NA). Coverage defined as the total number of reads supporting both included and excluded isoforms.}
}
\value{
An object of class S3 containing with new slots \code{$SpliceFeatureValidated$A3SS} and \code{$PSI$A3SS}.
}
\description{
Validate A3SS splicing events and subsequently computes percent spliced-in (PSI) values these high-quality splicing events.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- ComputePSI.A3SS(MarvelObject=marvel.demo,
                               CoverageThreshold=10
                               )
}
