% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_DROPLET_03_EXPLORE_EXPRESSION_1_Gene.R
\name{PlotPctExprCells.Genes.10x}
\alias{PlotPctExprCells.Genes.10x}
\title{Plot gene expression distribution}
\usage{
PlotPctExprCells.Genes.10x(
  MarvelObject,
  cell.group.g1,
  cell.group.g2,
  min.pct.cells = 1
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CheckAlignment.10x} function.}

\item{cell.group.g1}{Vector of character strings. Cell IDs corresponding to Group 1 (reference group) of downstream differential splice junction analysis.}

\item{cell.group.g2}{Vector of character strings. Cell IDs corresponding to Group 2 of downstream differential splice junction analysis.}

\item{min.pct.cells}{Numeric value. Minimum percentage of cells in which the gene is expressed for that gene to be included for gene expression distribution analysis. Expressed genes defined as genes with non-zero normalised UMI counts.}
}
\value{
An object of class S3 with a new slots \code{MarvelObject$pct.cells.expr$Gene$Plot} and \code{MarvelObject$pct.cells.expr$Gene$Data}.
}
\description{
Generates a plot of gene expression distribution (percentage of cells expressing a particular gene) to determine normalised gene expression threshold for downstream differential splice junction analysis.
}
\examples{

marvel.demo.10x <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.rds",
                               package="MARVEL")
                               )

# Define cell groups
    # Retrieve sample metadata
    sample.metadata <- marvel.demo.10x$sample.metadata

    # Group 1 (reference)
    index <- which(sample.metadata$cell.type=="iPSC")
    cell.ids.1 <- sample.metadata[index, "cell.id"]
    length(cell.ids.1)

    # Group 2
    index <- which(sample.metadata$cell.type=="Cardio day 10")
    cell.ids.2 <- sample.metadata[index, "cell.id"]
    length(cell.ids.2)

# Explore \% of cells expressing genes
marvel.demo.10x <- PlotPctExprCells.Genes.10x(
                        MarvelObject=marvel.demo.10x,
                        cell.group.g1=cell.ids.1,
                        cell.group.g2=cell.ids.2,
                        min.pct.cells=5
                        )

# Check output
marvel.demo.10x $pct.cells.expr$Gene$Plot
head(marvel.demo.10x $pct.cells.expr$Gene$Data)
}
