% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodesplit.functions.R
\name{ref.comparisons}
\alias{ref.comparisons}
\title{Identify unique comparisons relative to study reference treatment within a
network}
\usage{
ref.comparisons(data)
}
\arguments{
\item{data}{A data frame containing variables \code{studyID} and \code{treatment} (as
numeric codes) that indicate which treatments are used in which studies.}
}
\value{
A data frame of unique comparisons in which each row represents a
different comparison. \code{t1} and \code{t2} indicate the treatment codes that make
up the comparison. \code{nr} indicates the number of times the given comparison
is made within the network.

If there is only a single observation for each study within the dataset
(i.e. as for standard network meta-analysis) \code{nr} will represent the number
of studies that compare treatments \code{t1} and \code{t2}.

If there are multiple observations for each study within the dataset (as in
MBNMAtime) \code{nr} will represent the number of time points in the
dataset in which treatments \code{t1} and \code{t2} are compared.
}
\description{
Identify unique contrasts relative to each study reference within a network.
Repetitions of the same treatment comparison are grouped together.
}
\examples{
data <- data.frame(studyID=c(1,1,2,2,3,3,4,4,5,5,5),
  treatment=c(1,2,1,3,2,3,3,4,1,2,4)
  )

# Identify comparisons informed by direct and indirect evidence
MBNMAtime:::ref.comparisons(data)
}
