% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rBED.R
\name{rBED}
\alias{rBED}
\title{Bivariate generator of the bivariate exponential distribution (BED) based on the Moran-Downton model}
\usage{
rBED(rho,Betax,Betay,n)
}
\arguments{
\item{rho}{Correlation coefficient.}

\item{Betax}{Scale parameter of the marginal distribution of x.}

\item{Betay}{Scale parameter of the marginal distribution of y.}

\item{n}{Number of random values to be generated.}
}
\value{
A dataframe with n random values generated.
}
\description{
This function generates jointly random values from the BED. The required inputs are the n values to be
generated, the correlation coefficient, and the scale parameters of the marginal distributions.
}
\details{
The bivariate generator generates jointly exponential random values based on the conditional distribution
of Y given X=x based on Eq.18 described in \insertCite{Nagao1971;textual}{MDBED}. Thus, it first
generates random values of X; then, the conditional moments associated with the values of
x are computed. Finally, the random values of Y are obtained by drawing a random value from each conditional distribution
associated with each value of x.
}
\note{
The equation of the conditional PDF used to generate the bivariate values is based on the Bessel
function. Therefore, for very extreme values this function may reach infinity. It may
generate NA values. The \code{\link{rBED}} function is set to avoid this problem for values of n lower than
100000.
}
\examples{
rBED(n=100,Betax=1,Betay=1,rho=0.85)
}
\references{
\insertAllCited{}
}
\author{
Luis F. Duque <lfduquey@gmail.com> <l.f.duque-yaguache2@newcastle.ac.uk>
}
