# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Correlation matrix distance
#'
#' @description Computes the correlation matrix distance between two correlation matrices
#' @param x First correlation matrix
#' @param y Second correlation matrix
#' @return Returns the correlation matrix distance, which is a value between 0 and 1. The correlation matrix distance becomes
#' zero for equal correlation matrices and unity if they differ to a maximum extent.
#' @author Claus Ekstrom \email{claus@@rprimer.dk}
#' @references Herdin, M., and Czink, N., and Ozcelik, H., and Bonek, E. (2005). \emph{Correlation matrix distance, a meaningful measure for
#' evaluation of non-stationary mimo channels}. IEEE VTC.
#' @keywords univar
#' @examples
#'
#' m1 <- matrix(rep(1, 16), 4)
#' m2 <- matrix(c(1, 0, .5, .5, 0, 1, .5, .5, .5, .5, 1, .5, .5, .5, .5, 1), 4)
#' m3 <- matrix(c(1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1), 4)
#' cmd(m1, m1)
#' cmd(m1, m2)
#' cmd(m2, m3)
#'
#' @export cmd
cmd <- function(x, y) {
    .Call('MESS_cmd', PACKAGE = 'MESS', x, y)
}

#' Fill down NA with the last observed observation
#'
#' @description Fill down missing values with the latest non-missing value
#' @param x A vector
#' @return A vector or list with the NA's replaced by the last observed value.
#' @author Claus Ekstrom <claus@@rprimer.dk>
#' @examples
#'
#' a <- c(1:5, "Howdy", NA, NA, 2:3, NA)
#' filldown(a)
#' filldown(c(NA, NA, NA, 3:5))
#'
#' @export
filldown <- function(x) {
    .Call('MESS_filldown', PACKAGE = 'MESS', x)
}

#' Fast marginal simple regresion analyses
#'
#' @description Fast computation of simple regression slopes for each predictor represented by a column in a matrix
#' @param y A vector of outcomes.
#' @param x A matrix of regressor variables. Must have the same number of rows as the length of y.
#' @param addintercept A logical that determines if the intercept should be included in all analyses (TRUE) or not (FALSE)
#' @return A data frame with two variables: coefficients and stderr that gives the slope estimate and corresponding standard error for each column in x.
#' @author Claus Ekstrom <claus@@rprimer.dk>
#' @export
mfastLm_cpp <- function(y, x, addintercept) {
    .Call('MESS_mfastLm_cpp', PACKAGE = 'MESS', y, x, addintercept)
}

#' Fast extraction of matrix diagonal
#'
#' @description Fast extraction of matrix diagonal
#' @param x The matrix to extract the diagonal from
#' @return A vector with the diagonal elements
#' @details Note this function can only be used for extraction
#' @author Claus Ekstrom <claus@@rprimer.dk>
#' @export qdiag
qdiag <- function(x) {
    .Call('MESS_qdiag', PACKAGE = 'MESS', x)
}

#' Fast quadratic form computation
#'
#' @description Fast computation of a quadratic form  t(x) %*% M %*% x
#' @param x A matrix with dimensions n*k.
#' @param M A matrix with dimenions n*n. If it is to be inverted then the matrix should be symmetric and positive difinite (no check is done for this)
#' @param invertM A logical. If set to TRUE then M will be inverted before computations (defaults to FALSE)
#' @param transposex A logical. Should the matrix be transposed before computations (defaults to FALSE).
#' @return A matrix with dimensions k * k giving the quadratic form
#' @author Claus Ekstrom <claus@@rprimer.dk>
#' @export
quadform <- function(x, M, invertM = FALSE, transposex = FALSE) {
    .Call('MESS_quadform', PACKAGE = 'MESS', x, M, invertM, transposex)
}

#' Fast replication of a matrix
#'
#' @description Fast generation of a matrix by replicating a matrix row- and column-wise in a block-like fashion
#' @param x A matrix with dimensions r*c.
#' @param nrow An integer giving the number of times the matrix is replicated row-wise
#' @param ncol An integer giving the number of times the matrix is replicated column-wise
#' @return A matrix with dimensions (r*nrow) x (c*ncol)
#' @author Claus Ekstrom <claus@@rprimer.dk>
#' @export
repmat <- function(x, nrow = 1L, ncol = 1L) {
    .Call('MESS_repmat', PACKAGE = 'MESS', x, nrow, ncol)
}

#' Fast computation of trace of matrix product
#'
#' @description Fast computation of the trace of the matrix product trace(t(A) %*% B)
#' @param A A matrix with dimensions n*k.
#' @param B A matrix with dimenions n*k.
#' @return The trace of the matrix product
#' @author Claus Ekstrom <claus@@rprimer.dk>
#' @export
tracemp <- function(A, B) {
    .Call('MESS_tracemp', PACKAGE = 'MESS', A, B)
}

