% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MESS-package.R
\docType{data}
\name{greenland}
\alias{greenland}
\title{Average yearly summer air temperature for Tasiilaq, Greenland}
\format{A data frame with 51 observations on the following 2 variables.
\describe{ \item{year}{year} \item{airtemp}{average air
temperature (degrees Celcius)} }}
\source{
Data provided by Sebastian Mernild.\cr Originally obtained from
http://www.dmi.dk/dmi/index/gronland/vejrarkiv-gl.htm. \cr Added by Claus
Ekstrom <ekstrom@life.ku.dk>
}
\description{
Average yearly summer (June, July, August) air temperature for Tasiilaq,
Greenland
}
\examples{

data(greenland)
model <- lm(airtemp ~ year, data=greenland)
plot(greenland$year, greenland$airtemp, xlab="Year", ylab="Air temperature")
abline(model, col="red")

}
\references{
Aktuelt Naturvidenskab september 2010. \cr
http://aktuelnaturvidenskab.dk/fileadmin/an/nr-4/an4_2010gletscher.pdf
}
\keyword{datasets}
