% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Imperial-model-params.R
\name{imperial_model_param_list_create}
\alias{imperial_model_param_list_create}
\title{Model Parameter List Creation}
\usage{
imperial_model_param_list_create(
  eta = 1/(21 * 365),
  rho = 0.85,
  a0 = 2920,
  sigma2 = 1.67,
  max_age = 100 * 365,
  rA = 1/195,
  rT = 0.2,
  rD = 0.2,
  rU = 1/110.299,
  rP = 1/15,
  dE = 12,
  delayGam = 12.5,
  cD = 0.0676909,
  cT = 0.322 * cD,
  cU = 0.006203,
  gamma1 = 1.82425,
  d1 = 0.160527,
  dID = 3650,
  ID0 = 1.577533,
  kD = 0.476614,
  uD = 9.44512,
  aD = 8001.99,
  fD0 = 0.007055,
  gammaD = 4.8183,
  alphaA = 0.75735,
  alphaU = 0.185624,
  b0 = 0.590076,
  b1 = 0.5,
  dB = 3650,
  IB0 = 43.8787,
  kB = 2.15506,
  uB = 7.19919,
  phi0 = 0.791666,
  phi1 = 0.000737,
  dCA = 10950,
  IC0 = 18.02366,
  kC = 2.36949,
  uCA = 6.06349,
  PM = 0.774368,
  dCM = 67.6952,
  tau1 = 0.69,
  tau2 = 2.31,
  muF = 0.132,
  nEIP = 3,
  qEIP = 1/10,
  Q0 = 0.92,
  DY = 365,
  thetaB = 0.89,
  thetaI = 0.97,
  r_llin = 0.56,
  s_llin = 0.03,
  r_irs = 0.6,
  s_irs = 0,
  qE = 1/4,
  nE = 2,
  qL = 1/3,
  nL = 3,
  qP = 1/6,
  nP = 2,
  muE = 0.05,
  muL = 0.15,
  muP = 0.05,
  muM = 0.132,
  eps = 58.9,
  nu = 1/(4/24),
  NH = 1000,
  ...
)
}
\arguments{
\item{eta}{Death rate for expoential population distribtuion, i.e. 1/Mean Population Age. Default = 0.0001305}

\item{rho}{Age-dependent biting parameter. Default = 0.85}

\item{a0}{Age-dependent biting parameter. Default = 2920}

\item{sigma2}{Variance of the log heterogeneity in biting rates. Default = 1.67}

\item{max_age}{Maximum age in days. Default = 100*365}

\item{rA}{Rate of leaving asymptomatic infection. Default = 0.00512821}

\item{rT}{Rate of leaving treatment. Default = 0.2}

\item{rD}{Rate of leaving clinical disease. Default = 0.2}

\item{rU}{Rate of recovering from subpatent infection. Default = 0.00906627}

\item{rP}{Rate of leaving prophylaxis. Default = 0.06666667}

\item{dE}{Latent period of human infection. Default = 12}

\item{delayGam}{Lag from parasites to infectious gametocytes. Default = 12.5}

\item{cD}{Untreated disease contribution to infectiousness. Default = 0.0676909}

\item{cT}{Treated disease contribution to infectiousness. Default =   0.322 * cD}

\item{cU}{Subpatent disease contribution to infectiousness. Default = 0.006203}

\item{gamma1}{Parameter for infectiousness of state A. Default = 1.82425}

\item{d1}{Minimum probability due to maximum immunity. Default = 0.160527}

\item{dID}{Inverse of decay rate. Default = 3650}

\item{ID0}{Scale parameter. Default = 1.577533}

\item{kD}{Shape parameter. Default = 0.476614}

\item{uD}{Duration in which immunity is not boosted. Default = 9.44512}

\item{aD}{Scale parameter relating age to immunity. Default = 8001.99}

\item{fD0}{Time-scale at which immunity changes with age. Default = 0.007055}

\item{gammaD}{Shape parameter relating age to immunity. Default = 4.8183}

\item{alphaA}{PCR detection probability parameters state A. Default = 0.757}

\item{alphaU}{PCR detection probability parameters state U. Default = 0.186}

\item{b0}{Maximum probability due to no immunity. Default = 0.590076}

\item{b1}{Maximum relative reduction due to immunity. Default = 0.5}

\item{dB}{Inverse of decay rate. Default = 3650}

\item{IB0}{Scale parameter. Default = 43.8787}

\item{kB}{Shape parameter. Default = 2.15506}

\item{uB}{Duration in which immunity is not boosted. Default = 7.19919}

\item{phi0}{Maximum probability due to no immunity. Default = 0.791666}

\item{phi1}{Maximum relative reduction due to immunity. Default = 0.000737}

\item{dCA}{Inverse of decay rate. Default = 10950}

\item{IC0}{Scale parameter. Default = 18.02366}

\item{kC}{Shape parameter. Default = 2.36949}

\item{uCA}{Duration in which immunity is not boosted. Default = 6.06349}

\item{PM}{New-born immunity relative to mother’s. Default = 0.774368}

\item{dCM}{Inverse of decay rate of maternal immunity. Default = 67.6952}

\item{tau1}{Duration of host seeking, assumed to be constant between species. Default = 0.69}

\item{tau2}{Duration of mosquito resting after feed. Default = 2.31}

\item{muF}{Daily mortality of adult mosquitos. Default = 0.132}

\item{nEIP}{Number of Erlang-distributed EIP compartments. Default = 6}

\item{qEIP}{Inverse of the mean duration of the EIP. Default = 1/10 (days)}

\item{Q0}{Anthrophagy probability. Default = 0.92}

\item{DY}{number of days in a year}

\item{thetaB}{proportion of bites on a person in bed}

\item{thetaI}{proportion of bites on a person outdoors}

\item{r_llin}{probability of repeating a feeding attempt due to LLINs}

\item{s_llin}{probability of feeding and surviving in presence of LLINs}

\item{r_irs}{probability of repeating a feeding attempt due to IRS}

\item{s_irs}{probability of feeding and surviving in presence of IRS}

\item{qE}{mosquito egg lifecycle parameter}

\item{nE}{mosquito egg lifecycle parameter}

\item{qL}{mosquito larval lifecycle parameter}

\item{nL}{mosquito larval lifecycle parameter}

\item{qP}{mosquito pupae lifecycle parameter}

\item{nP}{mosquito pupae lifecycle parameter}

\item{muE}{death rate of egg stage}

\item{muL}{death rate of larval stage}

\item{muP}{death rate of pupae stage}

\item{muM}{death rate of male adult stage}

\item{eps}{eggs laid per day}

\item{nu}{mosquito lifecycle parameter}

\item{NH}{number of humans}

\item{...}{Any other parameters needed for non-standard model. If they share the same name
as any of the defined parameters \code{model_param_list_create} will stop. You can either write
any extra parameters you like individually, e.g. model_param_list_create(extra1 = 1, extra2 = 2)
and these parameteres will appear appended to the returned list, or you can pass explicitly
the ellipsis argument as a list created before, e.g. model_param_list_create(...=list(extra1 = 1, extra2 = 2))

This function creates all of the necessary parameters for the Imperial model. Parameters furnished by MGDrivE will be
removed from this function. Adapted from: https://github.com/mrc-ide/deterministic-malaria-model/blob/master/R/model_parameters.R}
}
\description{
\code{model_param_list_create} creates list of model parameters to be used
within \code{equilibrium_init_create}
}
