% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling-PTS.R
\name{step_PTS}
\alias{step_PTS}
\title{Make Poisson Time-Step (PTS) Sampler for a SPN Model}
\usage{
step_PTS(S, Sout, haz, dt = 0.01, maxhaz = 1e+06)
}
\arguments{
\item{S}{a stoichiometry \code{\link[Matrix]{Matrix-class}} object}

\item{Sout}{an optional matrix to track of event firings}

\item{haz}{a list of hazard functions}

\item{dt}{time-step for tau-leap method}

\item{maxhaz}{maximum allowable hazard}
}
\value{
function closure for use in \code{\link{sim_trajectory_R}} or \code{\link{sim_trajectory_CSV}}
}
\description{
Make a function closure to implement a Poisson time-step (tau-leaping with fixed tau)
sampler for a SPN.
}
\details{
This sampling algorithm is based on representing a SPN as a set of competing
Poisson processes; it thus uses an integer valued state space but approximates
the number of events over \code{dt}.

The design of \code{step_PTS} is from: Wilkinson, D. J. (2011). Stochastic
modeling for systems biology. CRC press

Elements of the \code{N} list come from two places: The stoichiometry matrix
(\code{S}) is generated in \code{\link{spn_S}} and the hazards (\code{h}) come
from \code{\link{spn_hazards}}.

For other samplers, see: \code{\link{step_CLE}}, \code{\link{step_DM}}, \code{\link{step_ODE}}
}
