% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary-analysis.R
\name{split_aggregate_CSV_decoupled}
\alias{split_aggregate_CSV_decoupled}
\title{Split CSV output for decoupled sampling with Imperial malaria model}
\usage{
split_aggregate_CSV_decoupled(
  read_dir,
  write_dir = read_dir,
  spn_P,
  tmax,
  dt,
  human_states,
  sum_fem = FALSE,
  rem_file = FALSE,
  verbose = TRUE,
  erlang = FALSE
)
}
\arguments{
\item{read_dir}{Directory where output was written to}

\item{write_dir}{Directory to write output to. Default is read_dir}

\item{spn_P}{Places object, see details}

\item{tmax}{The final time to end simulation}

\item{dt}{The time-step at which to return output (\strong{not} the time-step of the sampling algorithm)}

\item{human_states}{human state distribution}

\item{sum_fem}{if \code{TRUE}, in addition to FS, FE, FI output by node and repetition, output an
additional file F which sums over infection states (S,E,I). Does nothing if the
simulation did not include epi dynamics.}

\item{rem_file}{Remove original output? Default is FALSE}

\item{verbose}{Chatty? Default is TRUE}

\item{erlang}{erlang distributed states}
}
\value{
Writes output to files in write_dir
}
\description{
This function reads in the output files from \code{\link{sim_trajectory_CSV}}
and splits them into smaller files. The files are output by patch, with the
appropriate patch numbers for mosquitoes or humans, and specific stages are
aggregated by a given metric. \cr
}
\details{
Given the \code{read_dir}, this function assumes the follow file structure: \cr
\itemize{
\item read_dir
\itemize{
\item repetition 1
\itemize{
\item M.csv
\item FS.csv
\item ... \cr
}
\item repetition 2
\itemize{
\item M.csv
\item FS.csv
\item ... \cr
}
\item repetition 3
\item ... \cr
}
}

This function expects the \code{write_dir} to be empty, and it sets up the
same file structure as the \code{read_dir}. For a 2-node simulation, the output
will be organized similar to: \cr
\itemize{
\item write_dir
\itemize{
\item repetition 1
\itemize{
\item M_0001.csv
\item M_0002.csv
\item FS_0001.csv
\item FS_0001.csv
\item ... \cr
}
\item repetition 2
\itemize{
\item M_0001.csv
\item M_0002.csv
\item FS_0001.csv
\item FS_0001.csv
\item ... \cr
}
\item repetition 3
\item ... \cr
}
}

The places (\code{spn_P}) object is generated from one of the following:
\code{\link{spn_P_lifecycle_node}}, \code{\link{spn_P_lifecycle_network}},
\code{\link{spn_P_epiSIS_node}}, \code{\link{spn_P_epiSIS_network}},
\code{\link{spn_P_epiSEIR_node}}, or \code{\link{spn_P_epiSEIR_network}}.

\code{tmax}, \code{dt} define the last sampling
time, and each sampling time in-between.

For more details about using this function to process CSV output see:
\code{vignette("data-analysis", package = "MGDrivE2")}
}
