#' GetReplTable function
#'
#' \code{\link{GetReplTable}} uses the output files produced by the ReplMatch()
#' function to produce a table with the replicate sets and their respective mean
#' proportion of incongruent sequences.
#'
#' @param filepath is a user defined path to the folder where the output files
#'   from the ReplMatch() function have been saved.
#' @return  A table with the mean proportion of incongruent sequences for each
#'   replicate set.
#' @seealso \code{\link{ReplMatch}}; \code{\link{GetReplStats}}
#' @examples
#' filepath <- system.file("extdata/ReplMatchOut/", package="MHCtools")
#' GetReplTable(filepath)
#' @importFrom "rlist" "list.load"
#' @export

GetReplTable <- function(filepath) {

  # Get the file names of the .rdata output generated by the ReplMatch function

  file_names <- dir(filepath)

  # Sort the file names by  nest number

  file_names <- file_names[order(as.numeric(gsub("[^0-9]", "", file_names)))]

  mean_props <- numeric()

  # Extract the mean proportion of incongruent sequences for each replicate set

  for(i in 1:length(file_names)) {

    mean_props[i] <- list.load(file.path(filepath, file_names[i]))$Mean_prop_incongr_seqs

  }

  # List the observed mean proportions of incongruent sequences for each replicate set

  Table_obs_means <- as.data.frame(cbind(file_names, mean_props))

  Table_obs_means

}
