#' Fitting Markov-Modulated Linear Regression Models
#'
#' A set of tools for estimation of Markov-Modulated Linear Regression Models
#' @name MMLR-package
#' @docType package
#' @title Overview of Package MMLR
#' @author Nadezda Spiridovska \email{Spiridovska.N@@tsi.lv}
#' @keywords Markov-Modulated Linear Regression Models
#' @references
#' Andronov, A., Spiridovska, N. Markov-Modulated Linear Regression.
#' In proceedings’ book: International conference on Statistical Models and Methods
#' for Reliability and Survival Analysis and Their Validation (S2MRSA),
#' 2012, pp.24–28. Bordeaux, France (arXiv:1901.09600v1)
#'
#' Andronov A. Parameter statistical estimates of Markov-modulated linear regression,
#' in: Statistical Methods of Parameter Estimation and Hypothesis Testing 24,
#' Perm State University, Perm, Russia, 2012, pp. 163–180. (Russian).
#'
#' Alexander Andronov. Markov-modulated multivariate linear regression.
#' ACTA ET COMMENTATIONES UNIVERSITATIS TARTUENSIS DE MATHEMATICA. Volume 21, Number 1, June 2017.
#' DOI: 10.12697/ACUTM.2017.21.03
#'
#' @details
#' Acknowledgement. This work was financially supported by the specific support objective activity 1.1.1.2.
#' “Post-doctoral Research Aid” (Project id. N. 1.1.1.2/16/I/001) of the Republic of Latvia,
#' funded by the European Regional Development Fund. Nadezda Spiridovska research project No. 1.1.1.2/VIAA/1/16/075
#' “Non-traditional regression models in transport modelling”.





