% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalarization_ipbi.R
\name{scalarization_ipbi}
\alias{scalarization_ipbi}
\title{Inverted Penalty-based Boundary Intersection Scalarization}
\usage{
scalarization_ipbi(Y, W, maxP, aggfun, eps = 1e-16, ...)
}
\arguments{
\item{Y}{matrix of objective function values}

\item{W}{matrix of weights.}

\item{maxP}{numeric vector containing estimated ideal point}

\item{aggfun}{list containing parameters for the aggregation function. Must
contain the non-negative numeric constant \code{aggfun$theta}.}

\item{eps}{tolerance value for avoiding divisions by zero.}

\item{...}{other parameters (included for compatibility with generic call)}
}
\value{
Vector of scalarized performance values.
}
\description{
Perform inverted PBI Scalarization for the MOEADr package.
}
\details{
This routine calculates the scalarized performance values for the MOEA/D
using the inverted PBI method.
}
\section{References}{

H. Sato,
"Inverted PBI in MOEA/D and its impact on the search performance on multi
and many-objective optimization."
Proceedings of the 2014 Annual Conference on Genetic and
Evolutionary Computation (GECCO), 2014.

H. Sato,
"Analysis of inverted PBI and comparison with other scalarizing functions in
decomposition based MOEAs."
Journal of Heuristics 21(6):819-849, 2015
}

