% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot1D.R
\name{plot1D}
\alias{plot1D}
\title{Plot regions of the representative tree in 1D}
\usage{
plot1D(ans, type = "prob", group = 1, dim = 1, regions = rep(1,
  length(ans$RepresentativeTree$Levels)), legend = FALSE, main = "default",
  abs = TRUE)
}
\arguments{
\item{ans}{An \code{mrs} object.}

\item{type}{What is represented at each node.
The options are \code{type = c("eff", "prob")}.
Default is \code{type = "prob"}.}

\item{group}{If \code{type = "eff"}, which group effect size is used.
Default is \code{group = 1}.}

\item{dim}{If the data are multivariate, \code{dim} is the dimension plotted.
Default is \code{dim = 1}.}

\item{regions}{Binary vector indicating the regions to plot.
The default is to plot all regions.}

\item{legend}{Color legend for type. Default is \code{legend = FALSE}.}

\item{main}{Overall title for the plot.}

\item{abs}{If \code{TRUE}, plot the absolute value of the effect size.
Only used when \code{type = "eff"}.}
}
\description{
This function visualizes the regions of the representative tree
of the output of the \code{\link{mrs}} function.
For each region the posterior probability of difference (PMAP)  or the effect size is plotted.
}
\examples{
set.seed(1)
p = 1
n1 = 200
n2 = 200
mu1 = matrix( c(0,10), nrow = 2, byrow = TRUE)
mu2 = mu1; mu2[2] = mu1[2] + .01
sigma = c(1,.1)

Z1 = sample(2, n1, replace=TRUE, prob=c(0.9, 0.1))
Z2 = sample(2, n2, replace=TRUE, prob=c(0.9, 0.1))
X1 = mu1[Z1] + matrix(rnorm(n1*p), ncol=p)*sigma[Z1]
X2 = mu2[Z2] + matrix(rnorm(n2*p), ncol=p)*sigma[Z1]
X = rbind(X1, X2)
G = c(rep(1, n1), rep(2,n2))

ans = mrs(X, G, K=10)
plot1D(ans, type = "prob")
plot1D(ans, type = "eff")
}
\references{
Soriano J. and Ma L. (2017).
Probabilistic multi-resolution scanning for two-sample differences.
 \emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)}.
 \doi{10.1111/rssb.12180}

Ma L. and Soriano J. (2018).
Analysis of distributional variation through multi-scale Beta-Binomial modeling.
 \emph{Journal of Computational and Graphical Statistics. Vol. 27, No. 3, 529-541.}.
 \doi{10.1080/10618600.2017.1402774}
}

