% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSmix_functions_package.R
\name{spear_dist_distr}
\alias{spear_dist_distr}
\title{Spearman distance distribution under the uniform ranking model}
\usage{
spear_dist_distr(n_items, log = TRUE)
}
\arguments{
\item{n_items}{Number of items.}

\item{log}{Logical: whether the frequencies must be reported on the log scale. Defaults to \code{TRUE}.}
}
\value{
A list of two named objects:

\item{\code{distances}}{All the possible Spearman distance values (i.e., the support of the distribution).}
\item{\code{logcard}}{(Log)-frequencies corresponding to each value in \code{distances}.}
}
\description{
Provide (either the exact or the approximate) frequency distribution of the Spearman distance under the uniform (null) ranking model. Currently, it works for \eqn{n\leq 170}.
}
\details{
When \eqn{n\leq 20}, the exact distribution provided by OEIS Foundation Inc. (2023) is returned by relying on a call to the \code{get_cardinalities} routine of the \code{BayesMallows} package.

When \eqn{20<n\leq 170}, the approximate distribution introduced by Crispino et al. (2023) is returned.
}
\examples{

## Example 1. Exact Spearman distance distribution for n=20 items.
distr <- spear_dist_distr(n_items = 20, log = FALSE)
plot(distr$distances,distr$logcard,type='h',ylab = 'probability',xlab='d',
main='distribution of the spearman distance under the null model')


## Example 2. Approximate Spearman distance distribution for n=50 items with log-frequencies.
distr <- spear_dist_distr(n_items = 50)
plot(distr$distances,distr$logcard,type='h',ylab = 'log-probability',xlab='d',
    main='log-distribution of the spearman distance under the null model')

}
\references{
OEIS Foundation Inc. (2023). The On-Line Encyclopedia of Integer Sequences, Published electronically at \url{https://oeis.org}.

Crispino M, Mollica C, Astuti V and Tardella L (2023). Efficient and accurate inference for mixtures of Mallows models with Spearman distance. \emph{Statistics and Computing}, \bold{33}(98), DOI: 10.1007/s11222-023-10266-8.

Sørensen Ø, Crispino M, Liu Q and Vitelli V (2020). BayesMallows: An R Package for the Bayesian Mallows Model. \emph{The R Journal}, \bold{12}(1), pages 324--342, DOI: 10.32614/RJ-2020-026.
}
\seealso{
\code{\link{spear_dist}}, \code{\link{expected_spear_dist}}, \code{\link{partition_fun_spear}}
}
