% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{GetHypervolume}
\alias{GetHypervolume}
\title{Compute hypervolume}
\usage{
GetHypervolume(objective, reference = NULL, method = "exact")
}
\arguments{
\item{objective}{The set of points in the objective space (The objective values). A single column should contain one point, so the size would be numberOfObjective x nPoint, e.g. in 5 objective problem, it is 5 x n.}

\item{reference}{The reference points. Each column represent one point. Size: numberOfObjective x nPoint, e.g. in 5 objective problem, it is 5 x n.}

\item{method}{Exact using WFG method or approximate HV using the method by Bringmann and Friedrich. Default to "exact".}
}
\value{
Hypervolume size, a scalar value.
}
\description{
Compute the hypervolume formed by the points w.r.t. a reference point. If no reference is supplied, use the nadir point*(1.1,...,1.1).
}
\examples{
\donttest{
nObjective <- 5 # the number of objectives
nPoint <- 10 # the number of points that will form the hypervolume
objective <- matrix(stats::runif(nObjective*nPoint), nrow = nObjective, ncol = nPoint)
GetHypervolume(objective,,"exact") # no reference supplied

reference <- rep(2,nObjective) # create a reference point at (2,2,2,2,2)
GetHypervolume(objective,reference,"exact") # using reference point
}
}
