% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifolds.R
\name{Product manifold definition}
\alias{Product manifold definition}
\alias{get.product.defn}
\title{Product manifold definition}
\usage{
get.product.defn(...)
}
\arguments{
\item{...}{One or more simpler \link{Manifold definitions}}
}
\value{
List containing manifold definitions for the product manifold
}
\description{
Define a product manifold composed of simpler manifolds
}
\examples{
mani.defn1 <- get.product.defn(get.sphere.defn(n=5), get.spd.defn(n=5))
mani.defn2 <- get.product.defn(
    get.stiefel.defn(n=10, p=5),
    get.stiefel.defn(n=7, p=3),
    get.grassmann.defn(n=10, p=5)
)

\dontrun{
# --- Estimate jointly: Sigma in SPD manifold and mu in sphere manifold ---
library(mvtnorm)
n <- 400
p <- 3
mu.true <- rep(1/sqrt(p), p)
Sigma.true <- diag(2,p) + 0.1
y <- rmvnorm(n, mean = mu.true, sigma = Sigma.true)

tx <- function(x) {
    idx.mu <- 1:p
    idx.S <- 1:p^2 + p
    mu <- x[idx.mu]
    S <- matrix(x[idx.S], p, p)
    list(mu = mu, Sigma = S)
}
f <- function(x) {
    par <- tx(x)
    -sum(dmvnorm(y, mean = par$mu, sigma = par$Sigma, log = TRUE))
}

mod <- Module("ManifoldOptim_module", PACKAGE = "ManifoldOptim")
prob <- new(mod$RProblem, f)

mu0 <- diag(1, p)[,1]
Sigma0 <- diag(1, p)
x0 <- c(mu0, as.numeric(Sigma0))

mani.defn <- get.product.defn(get.sphere.defn(p), get.spd.defn(p))
mani.params <- get.manifold.params()
solver.params <- get.solver.params(isconvex = TRUE)

res <- manifold.optim(prob, mani.defn, method = "LRBFGS", 
    mani.params = mani.params, solver.params = solver.params, x0 = x0)
}

}

