% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{best_matches}
\alias{best_matches}
\title{For each market, find the best matching control market}
\usage{
best_matches(data=NULL,
             markets_to_be_matched=NULL,
             id_variable=NULL,
             date_variable=NULL,
             matching_variable=NULL,
             parallel=TRUE,
             warping_limit=1,
             start_match_period=NULL,
             end_match_period=NULL,
             matches=5,
             dtw_emphasis=1)
}
\arguments{
\item{data}{input data.frame for analysis. The dataset should be structured as "stacked" time series (i.e., a panel dataset).
In other words, markets are rows and not columns -- we have a unique row for each area/time combination.}

\item{markets_to_be_matched}{Use this parameter if you only want to get control matches for a subset of markets or a single market
The default is NULL which means that all markets will be paired with matching markets}

\item{id_variable}{the name of the variable that identifies the markets}

\item{date_variable}{the time stamp variable}

\item{matching_variable}{the variable (metric) used to match the markets. For example, this could be sales or new customers}

\item{parallel}{set to TRUE for parallel processing. Default is TRUE}

\item{warping_limit}{the warping limit used for matching. Default is 1, 
which means that a single query value can be mapped to at most 2 reference values.}

\item{start_match_period}{the start date of the matching period (pre period).
Must be a character of format "YYYY-MM-DD" -- e.g., "2015-01-01"}

\item{end_match_period}{the end date of the matching period (pre period).
Must be a character of format "YYYY-MM-DD" -- e.g., "2015-10-01"}

\item{matches}{Number of matching markets to keep in the output}

\item{dtw_emphasis}{Number from 0 to 1. The amount of emphasis placed on dtw distances, versus correlation, when ranking markets.
Default is 1 (all emphasis on dtw). If emphasis is set to 0, all emphasis would be put on correlation.
An emphasis of 0.5 would yield equal weighting.}
}
\value{
Returns an object of type \code{market_matching}. The object has the
following elements:

\item{\code{BestMatches}}{A data.frame that contains the best matches for each market in the input dataset}
\item{\code{Data}}{The raw data used to do the matching}
\item{\code{MarketID}}{The name of the market identifier}
\item{\code{MatchingMetric}}{The name of the matching variable}
\item{\code{DateVariable}}{The name of the date variable}
}
\description{
\code{best_matches} finds the best matching control markets for each market in the dataset
using dynamic time warping (\code{dtw} package). The algorithm simply loops through all viable candidates for each
market in a parallel fashion, and then ranks by distance and/or correlation.
}
\examples{
##-----------------------------------------------------------------------
## Find the best matches for the CPH airport time series
##-----------------------------------------------------------------------
library(MarketMatching)
data(weather, package="MarketMatching")
mm <- best_matches(data=weather, 
                   id="Area",
                   markets_to_be_matched=c("CPH", "SFO"),
                   date_variable="Date",
                   matching_variable="Mean_TemperatureF",
                   parallel=FALSE,
                   start_match_period="2014-01-01",
                   end_match_period="2014-10-01")
head(mm$BestMatches)

}
